/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

public enum CandidateType {
    Host,
    ServerReflexive,
    PeerReflexive,
    Relayed;


    public static CandidateType valueOf(int type) {
        switch (type) {
            case 0: {
                return Host;
            }
            case 1: {
                return ServerReflexive;
            }
            case 2: {
                return PeerReflexive;
            }
            case 3: {
                return Relayed;
            }
        }
        throw new IllegalArgumentException("Invalid candidate type(expected: 0 ~ 3, Gieven:" + type);
    }

    public int value() {
        switch (this) {
            case Host: {
                return 0;
            }
            case ServerReflexive: {
                return 1;
            }
            case PeerReflexive: {
                return 2;
            }
        }
        return 2;
    }

    public static String format(CandidateType type) {
        return String.format("%s[%d]", type.name(), type.value());
    }

    public String toString() {
        return CandidateType.format(this);
    }
}

