/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

public enum CloseReason {
    Normal,
    Timeout,
    Error;


    public static CloseReason valueOf(int reason) {
        switch (reason) {
            case 0: {
                return Normal;
            }
            case 1: {
                return Timeout;
            }
            case 2: {
                return Error;
            }
        }
        throw new IllegalArgumentException("Invalid close reason (expected: 0 ~ 2, Gieven:" + reason);
    }

    public int value() {
        switch (this) {
            case Normal: {
                return 0;
            }
            case Timeout: {
                return 1;
            }
        }
        return 2;
    }

    public static String format(CloseReason reason) {
        return String.format("%s[%d]", reason.name(), reason.value());
    }

    public String toString() {
        return CloseReason.format(this);
    }
}

