/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

import org.elastos.carrier.Carrier;
import org.elastos.carrier.Log;
import org.elastos.carrier.exceptions.CarrierException;
import org.elastos.carrier.session.ManagerHandler;
import org.elastos.carrier.session.Session;

public class Manager {
    private static final String TAG = "CarrierManager";
    private Carrier carrier;
    private boolean didCleanup;
    private long nativeCookie = 0L;

    private native boolean native_init(Carrier var1, ManagerHandler var2);

    private native void native_cleanup(Carrier var1);

    private static native Session create_session(Carrier var0, String var1);

    private static native int get_error_code();

    public static Manager createInstance(Carrier carrier) throws CarrierException {
        return Manager.createInstance(carrier, null);
    }

    public static Manager createInstance(Carrier carrier, ManagerHandler handler) throws CarrierException {
        if (carrier == null) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, "Attempt to create carrier session manager instance ...");
        Manager tmp = new Manager(carrier);
        if (!tmp.native_init(carrier, handler)) {
            throw CarrierException.fromErrorCode(Manager.get_error_code());
        }
        Log.d(TAG, "Carrier session manager instance created");
        return tmp;
    }

    private Manager(Carrier carrier) {
        this.carrier = carrier;
        this.didCleanup = false;
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    public synchronized void cleanup() {
        if (!this.didCleanup) {
            this.native_cleanup(this.carrier);
            this.carrier = null;
            this.didCleanup = true;
        }
    }

    public Session newSession(String to) throws CarrierException {
        if (to == null) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, "Attempt to create a new session to:" + to);
        Session session = Manager.create_session(this.carrier, to);
        if (session == null) {
            throw CarrierException.fromErrorCode(Manager.get_error_code());
        }
        Log.d(TAG, "Session to " + to + " created");
        return session;
    }
}

