/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

public enum NetworkTopology {
    LAN,
    P2P,
    Relayed;


    public static NetworkTopology valueOf(int type) {
        switch (type) {
            case 0: {
                return LAN;
            }
            case 1: {
                return P2P;
            }
            case 2: {
                return Relayed;
            }
        }
        throw new IllegalArgumentException("Invalid network topology (expected: 0 ~ 3, Gieven:" + type);
    }

    public int value() {
        switch (this) {
            case LAN: {
                return 0;
            }
            case P2P: {
                return 1;
            }
        }
        return 2;
    }

    public static String format(NetworkTopology type) {
        return String.format("%s[%d]", type.name(), type.value());
    }

    public String toString() {
        return NetworkTopology.format(this);
    }
}

