/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

import org.elastos.carrier.Log;
import org.elastos.carrier.exceptions.CarrierException;
import org.elastos.carrier.session.PortForwardingProtocol;
import org.elastos.carrier.session.SessionRequestCompleteHandler;
import org.elastos.carrier.session.Stream;
import org.elastos.carrier.session.StreamHandler;
import org.elastos.carrier.session.StreamType;

public class Session {
    private static final String TAG = "CarrierSession";
    private long nativeCookie = 0L;
    private String to;
    private boolean didClose;

    private native void session_close();

    private native boolean native_request(SessionRequestCompleteHandler var1);

    private native boolean native_reply_request(int var1, String var2);

    private native boolean native_start(String var1);

    private native Stream add_stream(StreamType var1, int var2, StreamHandler var3);

    private native boolean remove_stream(int var1, Stream var2);

    private native boolean add_service(String var1, PortForwardingProtocol var2, String var3, String var4);

    private native void remove_service(String var1);

    private static native int get_error_code();

    private Session(String to) {
        this.to = to;
        this.didClose = false;
        Log.d(TAG, "Session identityHashCode:" + System.identityHashCode(this));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public synchronized void close() {
        if (!this.didClose) {
            Log.d(TAG, "Closing session with " + this.to + " ...");
            Log.d(TAG, "close identityHashCode:" + System.identityHashCode(this));
            this.session_close();
            this.didClose = true;
            Log.d(TAG, "Session with " + this.to + " closed");
        }
    }

    public String getPeer() {
        return this.to;
    }

    public void request(SessionRequestCompleteHandler handler) throws CarrierException {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        if (!this.native_request(handler)) {
            throw CarrierException.fromErrorCode(Session.get_error_code());
        }
        Log.d(TAG, "Initiate session request to " + this.to);
    }

    public void replyRequest(int status, String reason) throws CarrierException {
        if (status != 0 && (reason == null || reason.length() == 0)) {
            throw new IllegalArgumentException();
        }
        if (!this.native_reply_request(status, reason)) {
            throw CarrierException.fromErrorCode(Session.get_error_code());
        }
        if (status == 0) {
            Log.d(TAG, "Confirmed session request from " + this.to);
        } else {
            Log.d(TAG, "Refused session request from " + this.to + " with reason " + reason);
        }
    }

    public void start(String sdp) throws CarrierException {
        if (sdp == null || sdp.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.native_start(sdp)) {
            throw CarrierException.fromErrorCode(Session.get_error_code());
        }
        Log.d(TAG, "Session to " + this.to + " started");
    }

    public Stream addStream(StreamType type, int options, StreamHandler handler) throws CarrierException {
        if (handler == null) {
            throw new IllegalArgumentException();
        }
        Log.d(TAG, String.format("Attempt to add stream (type:%s, options:%d)", new Object[]{type, options}));
        Stream stream = this.add_stream(type, options, handler);
        if (stream == null) {
            throw CarrierException.fromErrorCode(Session.get_error_code());
        }
        Log.d(TAG, String.format("Stream %d with %s type created", stream.getStreamId(), type.name()));
        return stream;
    }

    public void removeStream(Stream stream) throws CarrierException {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        if (!this.remove_stream(stream.getStreamId(), stream)) {
            throw CarrierException.fromErrorCode(Session.get_error_code());
        }
        Log.d(TAG, "Stream " + stream.getStreamId() + " was removed from session");
    }

    public void addService(String service, PortForwardingProtocol protocol, String host, String port) throws CarrierException {
        if (service == null || service.length() == 0 || host == null || host.length() == 0 || port == null || port.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this.add_service(service, protocol, host, port)) {
            throw CarrierException.fromErrorCode(Session.get_error_code());
        }
        Log.d(TAG, "Service " + service + " added to session");
    }

    public void removeService(String service) {
        if (service == null || service.length() == 0) {
            return;
        }
        this.remove_service(service);
        Log.d(TAG, "Service " + service + "was removed from session");
    }
}

