/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

import java.io.IOException;
import java.io.OutputStream;
import org.elastos.carrier.Log;
import org.elastos.carrier.exceptions.CarrierException;
import org.elastos.carrier.session.PortForwardingProtocol;
import org.elastos.carrier.session.StreamType;
import org.elastos.carrier.session.TransportInfo;

public class Stream {
    private static final String TAG = "CarrierStream";
    private long contextCookie = 0L;
    private long nativeCookie = 0L;
    private int streamId = 0;
    private StreamType type;
    public static int PROPERTY_COMPRESS = 1;
    public static int PROPERTY_PLAIN = 2;
    public static int PROPERTY_RELIABLE = 4;
    public static int PROPERTY_MULTIPLEXING = 8;
    public static int PROPERTY_PORT_FORWARDING = 16;

    private native boolean get_transport_info(int var1, TransportInfo var2);

    private native int write_stream_data(int var1, byte[] var2, int var3, int var4);

    private native int open_channel(int var1, String var2);

    private native boolean close_channel(int var1, int var2);

    private native int write_channel_data(int var1, int var2, byte[] var3, int var4, int var5);

    private native boolean pend_channel(int var1, int var2);

    private native boolean resume_channel(int var1, int var2);

    private native int open_port_forwarding(int var1, String var2, PortForwardingProtocol var3, String var4, String var5);

    private native boolean close_port_forwarding(int var1, int var2);

    private static native int get_error_code();

    private Stream(StreamType type) {
        this.type = type;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public StreamType getType() {
        return this.type;
    }

    public TransportInfo getTransportInfo() throws CarrierException {
        TransportInfo info = new TransportInfo();
        if (!this.get_transport_info(this.streamId, info)) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
        return info;
    }

    public int writeData(byte[] data, int offset, int len) throws CarrierException {
        if (data == null || data.length == 0 || offset < 0 || len <= 0 || offset + len > data.length) {
            throw new IllegalArgumentException();
        }
        int bytes = this.write_stream_data(this.streamId, data, offset, len);
        if (bytes < 0) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
        return bytes;
    }

    public int writeData(byte[] data) throws CarrierException {
        return this.writeData(data, 0, data.length);
    }

    public int writeData(byte data) throws CarrierException {
        byte[] _data = new byte[]{data};
        return this.writeData(_data);
    }

    public OutputStream getOutputStream() {
        return new ChannelOutputStream(this, -1);
    }

    public OutputStream getOutputStream(int channel) {
        if (channel <= 0) {
            throw new IllegalArgumentException();
        }
        return new ChannelOutputStream(this, channel);
    }

    public int openChannel(String cookie) throws CarrierException {
        if (cookie == null || cookie.length() == 0) {
            throw new IllegalArgumentException();
        }
        int channel = this.open_channel(this.streamId, cookie);
        if (channel < 0) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
        Log.d(TAG, String.format("Channel %d on stream %d created", channel, this.streamId));
        return channel;
    }

    public void closeChannel(int channel) throws CarrierException {
        if (channel <= 0) {
            throw new IllegalArgumentException();
        }
        boolean result = this.close_channel(this.streamId, channel);
        if (!result) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
        Log.d(TAG, String.format("Channel %d on stream %d closed", channel, this.streamId));
    }

    public int writeData(int channel, byte[] data, int offset, int len) throws CarrierException {
        if (channel <= 0 || data == null || data.length == 0 || offset < 0 || len <= 0 || offset + len > data.length) {
            throw new IllegalArgumentException();
        }
        int result = this.write_channel_data(this.streamId, channel, data, offset, len);
        if (result < 0) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
        return result;
    }

    public int writeData(int channel, byte[] data) throws CarrierException {
        return this.writeData(channel, data, 0, data.length);
    }

    public int writeData(int channel, byte data) throws CarrierException {
        byte[] _data = new byte[]{data};
        return this.writeData(channel, _data);
    }

    public void pendChannel(int channel) throws CarrierException {
        if (channel <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.pend_channel(this.streamId, channel)) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
    }

    public void resumeChannel(int channel) throws CarrierException {
        if (channel <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this.resume_channel(this.streamId, channel)) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
    }

    public int openPortForwarding(String service, PortForwardingProtocol protocol, String host, String port) throws CarrierException {
        if (service == null || service.length() == 0) {
            throw new IllegalArgumentException();
        }
        int pfId = this.open_port_forwarding(this.streamId, service, protocol, host, port);
        if (pfId < 0) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
        Log.d(TAG, String.format("Port forwarding %d to service %s created, and currently listening on %s://%s:%s", new Object[]{pfId, service, protocol, host, port}));
        return pfId;
    }

    public void closePortForwarding(int portForwarding) throws CarrierException {
        if (portForwarding <= 0) {
            throw new IllegalArgumentException();
        }
        boolean result = this.close_port_forwarding(this.streamId, portForwarding);
        if (!result) {
            throw CarrierException.fromErrorCode(Stream.get_error_code());
        }
        Log.d(TAG, String.format("Port forwarding %d closed nicely", portForwarding));
    }

    private class ChannelOutputStream
    extends OutputStream {
        private Stream stream;
        private int channel;

        ChannelOutputStream(Stream stream2, int channel) {
            this.stream = stream2;
            this.channel = channel;
        }

        ChannelOutputStream(Stream stream2) {
            this(stream2, -1);
        }

        @Override
        public void write(int i) throws IOException {
            try {
                if (this.channel < 0) {
                    this.stream.writeData((byte)i);
                } else {
                    this.stream.writeData(this.channel, (byte)i);
                }
            }
            catch (CarrierException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                if (this.channel < 0) {
                    this.stream.writeData(b);
                } else {
                    this.stream.writeData(this.channel, b);
                }
            }
            catch (CarrierException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(byte[] b, int offset, int len) throws IOException {
            try {
                if (this.channel < 0) {
                    this.stream.writeData(b, offset, len);
                } else {
                    this.stream.writeData(this.channel, b, offset, len);
                }
            }
            catch (CarrierException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws IOException {
            if (this.stream == null) {
                return;
            }
            try {
                if (this.channel > 0) {
                    this.stream.closeChannel(this.channel);
                    this.stream = null;
                    this.channel = -1;
                }
            }
            catch (CarrierException e) {
                throw new IOException(e);
            }
        }
    }
}

