/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

public enum StreamState {
    Initialized,
    TransportReady,
    Connecting,
    Connected,
    Deactivated,
    Closed,
    Error;


    public static StreamState valueOf(int state) {
        switch (state) {
            case 1: {
                return Initialized;
            }
            case 2: {
                return TransportReady;
            }
            case 3: {
                return Connecting;
            }
            case 4: {
                return Connected;
            }
            case 5: {
                return Deactivated;
            }
            case 6: {
                return Closed;
            }
            case 7: {
                return Error;
            }
        }
        throw new IllegalArgumentException("Invalid Stream State (expected: 1 ~ 7, Gieven:" + state);
    }

    public int value() {
        switch (this) {
            case Initialized: {
                return 1;
            }
            case TransportReady: {
                return 2;
            }
            case Connecting: {
                return 3;
            }
            case Connected: {
                return 4;
            }
            case Deactivated: {
                return 5;
            }
            case Closed: {
                return 6;
            }
        }
        return 7;
    }

    public static String format(StreamState state) {
        return String.format("%s", state.name());
    }

    public String toString() {
        return StreamState.format(this);
    }
}

