/*
 * Decompiled with CFR 0.152.
 */
package org.elastos.carrier.session;

public enum StreamType {
    Audio,
    Video,
    Text,
    Application,
    Message;


    public static StreamType valueOf(int type) {
        switch (type) {
            case 0: {
                return Audio;
            }
            case 1: {
                return Video;
            }
            case 2: {
                return Text;
            }
            case 3: {
                return Application;
            }
            case 4: {
                return Message;
            }
        }
        throw new IllegalArgumentException("Invalid Stream type (expected: 0 ~ 4, Gieven:" + type);
    }

    public int value() {
        switch (this) {
            case Audio: {
                return 0;
            }
            case Video: {
                return 1;
            }
            case Text: {
                return 2;
            }
            case Application: {
                return 3;
            }
            case Message: {
                return 4;
            }
        }
        return 5;
    }

    public static String format(StreamType type) {
        return String.format("%s", type.name());
    }

    public String toString() {
        return StreamType.format(this);
    }
}

