/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.logging;

import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.logging.Logger;
import org.eluder.coveralls.maven.plugin.source.ChainingSourceCallback;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;

public class CoverageTracingLogger
extends ChainingSourceCallback
implements Logger {
    private long files = 0L;
    private long lines = 0L;
    private long relevant = 0L;
    private long covered = 0L;

    public CoverageTracingLogger(SourceCallback chained) {
        super(chained);
    }

    public long getFiles() {
        return this.files;
    }

    public final long getLines() {
        return this.lines;
    }

    public final long getRelevant() {
        return this.relevant;
    }

    public final long getCovered() {
        return this.covered;
    }

    public final long getMissed() {
        return this.relevant - this.covered;
    }

    @Override
    public Logger.Position getPosition() {
        return Logger.Position.AFTER;
    }

    @Override
    public void log(Log log) {
        log.info((CharSequence)("Gathered code coverage metrics for " + this.getFiles() + " source files with " + this.getLines() + " lines of code:"));
        log.info((CharSequence)("- " + this.getRelevant() + " relevant lines"));
        log.info((CharSequence)("- " + this.getCovered() + " covered lines"));
        log.info((CharSequence)("- " + this.getMissed() + " missed lines"));
    }

    @Override
    protected void onSourceInternal(Source source) throws ProcessingException, IOException {
        if (source.getClassifier() == null) {
            ++this.files;
            this.lines += (long)source.getCoverage().length;
        }
        for (Integer coverage : source.getCoverage()) {
            if (coverage == null) continue;
            ++this.relevant;
            if (coverage <= 0) continue;
            ++this.covered;
        }
    }
}

