/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.parser;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.parser.AbstractXmlEventParser;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;

public class CoberturaParser
extends AbstractXmlEventParser {
    protected Source source;
    protected boolean inMethods;

    public CoberturaParser(File coverageFile, SourceLoader sourceLoader) {
        super(coverageFile, sourceLoader);
    }

    @Override
    protected void onEvent(XMLStreamReader xml, SourceCallback callback) throws XMLStreamException, ProcessingException, IOException {
        if (this.isStartElement(xml, "class")) {
            this.source = this.loadSource(xml.getAttributeValue(null, "filename"));
            String className = xml.getAttributeValue(null, "name");
            int classifierPosition = className.indexOf(36);
            if (classifierPosition > 0) {
                this.source.setClassifier(className.substring(classifierPosition + 1));
            }
        } else if (this.isStartElement(xml, "methods") && this.source != null) {
            this.inMethods = true;
        } else if (this.isEndElement(xml, "methods") && this.source != null) {
            this.inMethods = false;
        } else if (this.isStartElement(xml, "line") && !this.inMethods && this.source != null) {
            this.source.addCoverage(Integer.parseInt(xml.getAttributeValue(null, "number")), Integer.valueOf(xml.getAttributeValue(null, "hits")));
        } else if (this.isEndElement(xml, "class") && this.source != null) {
            callback.onSource(this.source);
            this.source = null;
        }
    }
}

