/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import org.codehaus.plexus.util.IOUtil;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;

public abstract class AbstractSourceLoader
implements SourceLoader {
    private final Charset sourceEncoding;
    private final String directoryPrefix;

    public AbstractSourceLoader(URI base, URI sourceBase, String sourceEncoding) {
        this.sourceEncoding = Charset.forName(sourceEncoding);
        this.directoryPrefix = base.relativize(sourceBase).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source load(String sourceFile) throws IOException {
        InputStream stream = this.locate(sourceFile);
        if (stream != null) {
            InputStreamReader reader = new InputStreamReader(stream, this.getSourceEncoding());
            try {
                String source = IOUtil.toString((Reader)reader);
                Source source2 = new Source(this.getFileName(sourceFile), source);
                return source2;
            }
            finally {
                IOUtil.close((Reader)reader);
            }
        }
        return null;
    }

    protected Charset getSourceEncoding() {
        return this.sourceEncoding;
    }

    protected String getFileName(String sourceFile) {
        return this.directoryPrefix + sourceFile;
    }

    protected abstract InputStream locate(String var1) throws IOException;
}

