/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.source;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;

public class UniqueSourceCallback
implements SourceCallback {
    private static final String LINES_SEPARATOR = "#";
    private final Set<String> cache = new HashSet<String>();
    private final SourceCallback delegate;

    public UniqueSourceCallback(SourceCallback delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onSource(Source source) throws ProcessingException, IOException {
        String key = this.getKey(source);
        if (!this.cache.contains(key)) {
            this.cache.add(key);
            this.delegate.onSource(source);
        }
    }

    private String getKey(Source source) {
        return source.getFullName() + LINES_SEPARATOR + this.getRelevantLines(source);
    }

    private int getRelevantLines(Source source) {
        int relevant = 0;
        for (Integer cov : source.getCoverage()) {
            if (cov == null) continue;
            ++relevant;
        }
        return relevant;
    }
}

