/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import org.embulk.spi.Column;
import org.embulk.spi.Page;
import org.embulk.spi.Schema;
import org.embulk.spi.time.Timestamp;
import org.msgpack.value.Value;

public class PageReader
implements AutoCloseable {
    private static final ClassLoader CLASS_LOADER = PageReader.class.getClassLoader();
    private final PageReader delegate;

    PageReader() {
        this.delegate = null;
    }

    private PageReader(PageReader delegate) {
        this.delegate = delegate;
    }

    public PageReader(Schema schema) {
        this(PageReader.createImplInstance(schema));
    }

    public static int getRecordCount(Page page) {
        return PageReader.callGetRecordCount(page);
    }

    public void setPage(Page page) {
        this.delegate.setPage(page);
    }

    public Schema getSchema() {
        return this.delegate.getSchema();
    }

    public boolean isNull(Column column) {
        return this.delegate.isNull(column);
    }

    public boolean isNull(int columnIndex) {
        return this.delegate.isNull(columnIndex);
    }

    public boolean getBoolean(Column column) {
        return this.delegate.getBoolean(column);
    }

    public boolean getBoolean(int columnIndex) {
        return this.delegate.getBoolean(columnIndex);
    }

    public long getLong(Column column) {
        return this.delegate.getLong(column);
    }

    public long getLong(int columnIndex) {
        return this.delegate.getLong(columnIndex);
    }

    public double getDouble(Column column) {
        return this.delegate.getDouble(column);
    }

    public double getDouble(int columnIndex) {
        return this.delegate.getDouble(columnIndex);
    }

    public String getString(Column column) {
        return this.delegate.getString(column);
    }

    public String getString(int columnIndex) {
        return this.delegate.getString(columnIndex);
    }

    @Deprecated
    public Timestamp getTimestamp(Column column) {
        return this.delegate.getTimestamp(column);
    }

    @Deprecated
    public Timestamp getTimestamp(int columnIndex) {
        return this.delegate.getTimestamp(columnIndex);
    }

    public Instant getTimestampInstant(Column column) {
        return this.delegate.getTimestampInstant(column);
    }

    public Instant getTimestampInstant(int columnIndex) {
        return this.delegate.getTimestampInstant(columnIndex);
    }

    public Value getJson(Column column) {
        return this.delegate.getJson(column);
    }

    public Value getJson(int columnIndex) {
        return this.delegate.getJson(columnIndex);
    }

    public boolean nextRecord() {
        return this.delegate.nextRecord();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private static PageReader createImplInstance(Schema schema) {
        try {
            return (PageReader)Holder.CONSTRUCTOR.newInstance(schema);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            throw new LinkageError("[FATAL] org.embulk.spi.PageReaderImpl is invalid.", ex);
        }
        catch (InvocationTargetException ex) {
            PageReader.throwCheckedForcibly(ex.getTargetException());
            return null;
        }
    }

    private static int callGetRecordCount(Page page) {
        Object result;
        try {
            result = Holder.GET_RECORD_COUNT.invoke(null, page);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new LinkageError("[FATAL] org.embulk.spi.PageReaderImpl is invalid.", ex);
        }
        catch (InvocationTargetException ex) {
            PageReader.throwCheckedForcibly(ex.getTargetException());
            return Integer.MIN_VALUE;
        }
        if (result == null) {
            throw new LinkageError("[FATAL] org.embulk.spi.PageReaderImpl is invalid.", new NullPointerException("PageReaderImpl#getRecordCount returned null."));
        }
        if (!(result instanceof Integer)) {
            throw new LinkageError("[FATAL] org.embulk.spi.PageReaderImpl is invalid.", new ClassCastException("PageReaderImpl#getRecordCount returned non-int."));
        }
        return (Integer)result;
    }

    private static Class<PageReader> loadPageReaderImpl() throws ClassNotFoundException {
        return CLASS_LOADER.loadClass("org.embulk.spi.PageReaderImpl");
    }

    private static void throwCheckedForcibly(Throwable ex) {
        PageReader.throwCheckedForciblyInternal(ex);
    }

    private static <E extends Throwable> void throwCheckedForciblyInternal(Throwable ex) throws E {
        throw ex;
    }

    private static class Holder {
        private static final Class<PageReader> IMPL_CLASS;
        private static final Constructor<PageReader> CONSTRUCTOR;
        private static final Method GET_RECORD_COUNT;

        private Holder() {
        }

        static {
            try {
                IMPL_CLASS = PageReader.loadPageReaderImpl();
            }
            catch (ClassNotFoundException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.PageReaderImpl is not found.", ex);
            }
            try {
                CONSTRUCTOR = IMPL_CLASS.getConstructor(Schema.class);
            }
            catch (NoSuchMethodException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.PageReaderImpl does not have an expected constructor.", ex);
            }
            try {
                GET_RECORD_COUNT = IMPL_CLASS.getMethod("getRecordCount", Page.class);
            }
            catch (NoSuchMethodException ex) {
                throw new LinkageError("[FATAL] org.embulk.spi.PageReaderImpl does not have a static method 'getRecordCount'.", ex);
            }
        }
    }
}

