/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.SchemaConfigException;
import org.embulk.spi.type.Type;

public class Schema {
    private final List<Column> columns;

    public static Builder builder() {
        return new Builder();
    }

    public Schema(List<Column> columns) {
        this.columns = Collections.unmodifiableList(new ArrayList<Column>(columns));
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public int size() {
        return this.columns.size();
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public Column getColumn(int index) {
        return this.columns.get(index);
    }

    public String getColumnName(int index) {
        return this.getColumn(index).getName();
    }

    public Type getColumnType(int index) {
        return this.getColumn(index).getType();
    }

    public void visitColumns(ColumnVisitor visitor) {
        for (Column column : this.columns) {
            column.visit(visitor);
        }
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public Column lookupColumn(String name) {
        for (Column c : this.columns) {
            if (!c.getName().equals(name)) continue;
            return c;
        }
        throw new SchemaConfigException(String.format("Column '%s' is not found", name));
    }

    public int getFixedStorageSize() {
        int total = 0;
        for (Column column : this.columns) {
            total += column.getType().getFixedStorageSize();
        }
        return total;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof Schema)) {
            return false;
        }
        Schema other = (Schema)otherObject;
        return Objects.equals(this.columns, other.columns);
    }

    public int hashCode() {
        return Objects.hashCode(this.columns);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("Schema{\n");
        for (Column c : this.columns) {
            sbuf.append(String.format(" %4d: %s %s%n", c.getIndex(), c.getName(), c.getType()));
        }
        sbuf.append("}");
        return sbuf.toString();
    }

    public static class Builder {
        private final ArrayList<Column> columns = new ArrayList();
        private int index = 0;

        public synchronized Builder add(String name, Type type) {
            this.columns.add(new Column(this.index++, name, type));
            return this;
        }

        public Schema build() {
            return new Schema(Collections.unmodifiableList(this.columns));
        }
    }
}

