/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.embulk.spi.json.JsonLong;
import org.embulk.spi.json.JsonNumber;
import org.embulk.spi.json.JsonValue;
import org.msgpack.value.FloatValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableDoubleValueImpl;

public final class JsonDouble
implements JsonNumber {
    private final ImmutableDoubleValueImpl value;
    private final String literal;

    private JsonDouble(double value, String literal) {
        if (Double.isNaN(value)) {
            throw new ArithmeticException("JsonDouble does not accept NaN.");
        }
        if (Double.isInfinite(value)) {
            throw new ArithmeticException("JsonDouble does not accept the infinity.");
        }
        this.value = new ImmutableDoubleValueImpl(value);
        this.literal = literal;
    }

    private JsonDouble(ImmutableDoubleValueImpl msgpackValue) {
        this.value = msgpackValue;
        this.literal = null;
    }

    static JsonDouble fromMsgpack(FloatValue msgpackValue) {
        return new JsonDouble((ImmutableDoubleValueImpl)msgpackValue.immutableValue());
    }

    public static JsonDouble of(double value) {
        return new JsonDouble(value, null);
    }

    public static JsonDouble withLiteral(double value, String literal) {
        return new JsonDouble(value, literal);
    }

    @Override
    public JsonValue.EntityType getEntityType() {
        return JsonValue.EntityType.DOUBLE;
    }

    @Override
    public JsonDouble asJsonDouble() {
        return this;
    }

    @Override
    public int presumeReferenceSizeInBytes() {
        if (this.literal == null) {
            return 8;
        }
        return this.literal.length() * 2 + 8;
    }

    @Override
    public boolean isIntegral() {
        double inner = this.value.toDouble();
        return inner == Math.rint(inner);
    }

    @Override
    public boolean isByteValue() {
        return this.isIntegral() && -128.0 <= this.value.toDouble() && this.value.toDouble() <= 127.0;
    }

    @Override
    public boolean isShortValue() {
        return this.isIntegral() && -32768.0 <= this.value.toDouble() && this.value.toDouble() <= 32767.0;
    }

    @Override
    public boolean isIntValue() {
        return this.isIntegral() && -2.147483648E9 <= this.value.toDouble() && this.value.toDouble() <= 2.147483647E9;
    }

    @Override
    public boolean isLongValue() {
        return this.isIntegral() && -9.223372036854776E18 <= this.value.toDouble() && this.value.toDouble() <= 9.223372036854776E18;
    }

    @Override
    public byte byteValue() {
        return this.value.toByte();
    }

    @Override
    public byte byteValueExact() {
        if (!this.isByteValue()) {
            throw new ArithmeticException("Out of the range of byte, or not integral: " + this.value);
        }
        return this.value.toByte();
    }

    @Override
    public short shortValue() {
        return this.value.toShort();
    }

    @Override
    public short shortValueExact() {
        if (!this.isShortValue()) {
            throw new ArithmeticException("Out of the range of short, or not integral: " + this.value);
        }
        return this.value.toShort();
    }

    @Override
    public int intValue() {
        return this.value.toInt();
    }

    @Override
    public int intValueExact() {
        if (!this.isIntValue()) {
            throw new ArithmeticException("Out of the range of int, or not integral: " + this.value);
        }
        return this.value.toInt();
    }

    @Override
    public long longValue() {
        return this.value.toLong();
    }

    @Override
    public long longValueExact() {
        if (!this.isLongValue()) {
            throw new ArithmeticException("Out of the range of long, or not integral: " + this.value);
        }
        return this.value.toLong();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigDecimal.valueOf(this.value.toDouble()).toBigInteger();
    }

    @Override
    public BigInteger bigIntegerValueExact() {
        return BigDecimal.valueOf(this.value.toDouble()).toBigIntegerExact();
    }

    @Override
    public float floatValue() {
        return this.value.toFloat();
    }

    @Override
    public double doubleValue() {
        return this.value.toDouble();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value.toDouble());
    }

    @Override
    public String toJson() {
        if (this.literal != null) {
            return this.literal;
        }
        return Double.toString(this.value.toDouble());
    }

    @Override
    @Deprecated
    public Value toMsgpack() {
        return this.value;
    }

    public String toString() {
        return Double.toString(this.value.toDouble());
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject instanceof JsonDouble) {
            JsonDouble other = (JsonDouble)otherObject;
            return this.value.equals((Object)other.value);
        }
        if (otherObject instanceof JsonLong) {
            JsonLong other = (JsonLong)otherObject;
            return this.isLongValue() && this.value.toLong() == other.longValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

