/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.spi.json;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.embulk.spi.json.JsonString;
import org.embulk.spi.json.JsonValue;
import org.msgpack.value.MapValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableMapValueImpl;
import org.msgpack.value.impl.ImmutableStringValueImpl;

public final class JsonObject
extends AbstractMap<String, JsonValue>
implements JsonValue {
    private static final JsonObject EMPTY = new JsonObject(new String[0], new JsonValue[0]);
    private final String[] keys;
    private final JsonValue[] values;
    private ImmutableMapValueImpl msgpackMapCache;

    private JsonObject(String[] keys, JsonValue[] values) {
        this.keys = keys;
        this.values = values;
        this.msgpackMapCache = null;
    }

    private JsonObject(String[] keys, JsonValue[] values, ImmutableMapValueImpl msgpackValue) {
        this.keys = keys;
        this.values = values;
        this.msgpackMapCache = msgpackValue;
    }

    static JsonObject fromMsgpack(MapValue msgpackValue) {
        ImmutableMapValueImpl immutable = (ImmutableMapValueImpl)msgpackValue.immutableValue();
        int size = immutable.size();
        String[] keys = new String[size];
        JsonValue[] values = new JsonValue[size];
        Value[] array = immutable.getKeyValueArray();
        for (int i = 0; i < size; ++i) {
            Value keyMsgpack = array[i * 2];
            if (!keyMsgpack.isStringValue()) {
                throw new IllegalArgumentException("MessagePack's Map has a non-String key.");
            }
            keys[i] = ((StringValue)keyMsgpack).asString();
            Value valueMsgpack = array[i * 2 + 1];
            values[i] = JsonValue.fromMsgpack(valueMsgpack);
        }
        return new JsonObject(keys, values, immutable);
    }

    public static JsonObject of() {
        return EMPTY;
    }

    public static JsonObject of(String k1, JsonValue v1) {
        return new JsonObject(JsonObject.buildKeys(k1), JsonObject.buildValues(v1));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2) {
        return new JsonObject(JsonObject.buildKeys(k1, k2), JsonObject.buildValues(v1, v2));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3), JsonObject.buildValues(v1, v2, v3));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3, String k4, JsonValue v4) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3, k4), JsonObject.buildValues(v1, v2, v3, v4));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3, String k4, JsonValue v4, String k5, JsonValue v5) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3, k4, k5), JsonObject.buildValues(v1, v2, v3, v4, v5));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3, String k4, JsonValue v4, String k5, JsonValue v5, String k6, JsonValue v6) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3, k4, k5, k6), JsonObject.buildValues(v1, v2, v3, v4, v5, v6));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3, String k4, JsonValue v4, String k5, JsonValue v5, String k6, JsonValue v6, String k7, JsonValue v7) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3, k4, k5, k6, k7), JsonObject.buildValues(v1, v2, v3, v4, v5, v6, v7));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3, String k4, JsonValue v4, String k5, JsonValue v5, String k6, JsonValue v6, String k7, JsonValue v7, String k8, JsonValue v8) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3, k4, k5, k6, k7, k8), JsonObject.buildValues(v1, v2, v3, v4, v5, v6, v7, v8));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3, String k4, JsonValue v4, String k5, JsonValue v5, String k6, JsonValue v6, String k7, JsonValue v7, String k8, JsonValue v8, String k9, JsonValue v9) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3, k4, k5, k6, k7, k8, k9), JsonObject.buildValues(v1, v2, v3, v4, v5, v6, v7, v8, v9));
    }

    public static JsonObject of(String k1, JsonValue v1, String k2, JsonValue v2, String k3, JsonValue v3, String k4, JsonValue v4, String k5, JsonValue v5, String k6, JsonValue v6, String k7, JsonValue v7, String k8, JsonValue v8, String k9, JsonValue v9, String k10, JsonValue v10) {
        return new JsonObject(JsonObject.buildKeys(k1, k2, k3, k4, k5, k6, k7, k8, k9, k10), JsonObject.buildValues(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10));
    }

    public static JsonObject of(JsonValue ... keyValues) {
        if (keyValues == null) {
            throw new NullPointerException("key-value is null.");
        }
        if (keyValues.length == 0) {
            return EMPTY;
        }
        if (keyValues.length % 2 != 0) {
            throw new IllegalArgumentException("Even numbers of arguments must be specified to JsonObject#of(...).");
        }
        String[] keys = new String[keyValues.length / 2];
        JsonValue[] values = new JsonValue[keyValues.length / 2];
        for (int i = 0; i < keyValues.length / 2; ++i) {
            if (keyValues[i * 2] == null || keyValues[i * 2 + 1] == null) {
                throw new NullPointerException("keys or values has null.");
            }
            if (!(keyValues[i * 2] instanceof JsonString)) {
                throw new IllegalArgumentException("JsonString must be specified as a key for JsonObject#of(...).");
            }
            keys[i] = ((JsonString)keyValues[i * 2]).getString();
            values[i] = keyValues[i * 2 + 1];
        }
        return new JsonObject(keys, values);
    }

    @SafeVarargs
    public static JsonObject ofEntries(Map.Entry<String, JsonValue> ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is null.");
        }
        String[] keys = new String[entries.length];
        JsonValue[] values = new JsonValue[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) {
                throw new NullPointerException("entries has null.");
            }
            keys[i] = entries[i].getKey();
            if (keys[i] == null) {
                throw new NullPointerException("entries has null key.");
            }
            values[i] = entries[i].getValue();
            if (values[i] != null) continue;
            throw new NullPointerException("entries has null value.");
        }
        return new JsonObject(keys, values);
    }

    @SafeVarargs
    public static JsonObject ofEntriesWithJsonStringKeys(Map.Entry<JsonString, JsonValue> ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is null.");
        }
        String[] keys = new String[entries.length];
        JsonValue[] values = new JsonValue[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) {
                throw new NullPointerException("entries has null.");
            }
            JsonString key = entries[i].getKey();
            if (key == null) {
                throw new NullPointerException("entries has null key.");
            }
            keys[i] = key.getString();
            values[i] = entries[i].getValue();
            if (values[i] != null) continue;
            throw new NullPointerException("entries has null value.");
        }
        return new JsonObject(keys, values);
    }

    public static JsonObject ofMap(Map<String, JsonValue> map) {
        if (map == null) {
            throw new NullPointerException("map is null.");
        }
        String[] keys = new String[map.size()];
        JsonValue[] values = new JsonValue[map.size()];
        int index = 0;
        for (Map.Entry<String, JsonValue> pair : map.entrySet()) {
            keys[index] = pair.getKey();
            if (keys[index] == null) {
                throw new NullPointerException("map has null key.");
            }
            values[index] = pair.getValue();
            if (values[index] == null) {
                throw new NullPointerException("map has null value.");
            }
            ++index;
        }
        return new JsonObject(keys, values);
    }

    public static JsonObject ofMapWithJsonStringKeys(Map<JsonString, JsonValue> map) {
        if (map == null) {
            throw new NullPointerException("map is null.");
        }
        String[] keys = new String[map.size()];
        JsonValue[] values = new JsonValue[map.size()];
        int index = 0;
        for (Map.Entry<JsonString, JsonValue> pair : map.entrySet()) {
            JsonString key = pair.getKey();
            if (key == null) {
                throw new NullPointerException("map has null key.");
            }
            keys[index] = key.getString();
            values[index] = pair.getValue();
            if (values[index] == null) {
                throw new NullPointerException("map has null value.");
            }
            ++index;
        }
        return new JsonObject(keys, values);
    }

    public static JsonObject ofUnsafe(String[] keys, JsonValue[] values) {
        return new JsonObject(keys, values);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Map.Entry<String, JsonValue> entry(String key, JsonValue value) {
        if (key == null) {
            throw new NullPointerException("key is null.");
        }
        if (value == null) {
            throw new NullPointerException("value is null.");
        }
        return new AbstractMap.SimpleEntry<String, JsonValue>(key, value);
    }

    public static Map.Entry<JsonString, JsonValue> entry(JsonString key, JsonValue value) {
        if (key == null) {
            throw new NullPointerException("key is null.");
        }
        if (value == null) {
            throw new NullPointerException("value is null.");
        }
        return new AbstractMap.SimpleEntry<JsonString, JsonValue>(key, value);
    }

    @Override
    public JsonValue.EntityType getEntityType() {
        return JsonValue.EntityType.OBJECT;
    }

    @Override
    public JsonObject asJsonObject() {
        return this;
    }

    @Override
    public int presumeReferenceSizeInBytes() {
        int sum = 4;
        for (int i = 0; i < this.values.length; ++i) {
            sum += this.keys[i].length() * 2 + 4;
            sum += this.values[i].presumeReferenceSizeInBytes();
        }
        return sum;
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return new EntrySet(this.keys, this.values);
    }

    public JsonValue[] getKeyValueArray() {
        JsonValue[] keyValues = new JsonValue[this.keys.length * 2];
        for (int i = 0; i < this.keys.length; ++i) {
            keyValues[i * 2] = JsonString.of(this.keys[i]);
            keyValues[i * 2 + 1] = this.values[i];
        }
        return keyValues;
    }

    @Override
    public String toJson() {
        if (this.keys.length == 0) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(JsonString.escapeStringForJsonLiteral(this.keys[0]));
        builder.append(":");
        builder.append(this.values[0].toJson());
        for (int i = 1; i < this.keys.length; ++i) {
            builder.append(",");
            builder.append(JsonString.escapeStringForJsonLiteral(this.keys[i]));
            builder.append(":");
            builder.append(this.values[i].toJson());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    @Deprecated
    public Value toMsgpack() {
        if (this.msgpackMapCache != null) {
            return this.msgpackMapCache;
        }
        Value[] msgpackKeyValues = new Value[this.keys.length * 2];
        for (int i = 0; i < this.keys.length; ++i) {
            msgpackKeyValues[i * 2] = new ImmutableStringValueImpl(this.keys[i]);
            msgpackKeyValues[i * 2 + 1] = this.values[i].toMsgpack();
        }
        this.msgpackMapCache = new ImmutableMapValueImpl(msgpackKeyValues);
        return this.msgpackMapCache;
    }

    @Override
    public String toString() {
        if (this.keys.length == 0) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append(JsonString.escapeStringForJsonLiteral(this.keys[0]));
        builder.append(":");
        builder.append(this.values[0].toString());
        for (int i = 1; i < this.keys.length; ++i) {
            builder.append(",");
            builder.append(JsonString.escapeStringForJsonLiteral(this.keys[i]));
            builder.append(":");
            builder.append(this.values[i].toString());
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (!(otherObject instanceof JsonObject)) {
            return false;
        }
        JsonObject other = (JsonObject)otherObject;
        return Objects.equals(this.entrySet(), other.entrySet());
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            hash += this.keys[i].hashCode() ^ this.values[i].hashCode();
        }
        return hash;
    }

    private static String[] buildKeys(String ... keys) {
        for (String key : keys) {
            if (key != null) continue;
            throw new NullPointerException("key is null.");
        }
        return keys;
    }

    private static JsonValue[] buildValues(JsonValue ... values) {
        for (JsonValue value : values) {
            if (value != null) continue;
            throw new NullPointerException("value is null.");
        }
        return values;
    }

    private static class EntryIterator
    implements Iterator<Map.Entry<String, JsonValue>> {
        private final String[] keys;
        private final JsonValue[] values;
        private int index;

        EntryIterator(String[] keys, JsonValue[] values) {
            this.keys = keys;
            this.values = values;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keys.length;
        }

        @Override
        public Map.Entry<String, JsonValue> next() {
            if (this.index >= this.values.length) {
                throw new NoSuchElementException();
            }
            String key = this.keys[this.index];
            JsonValue value = this.values[this.index];
            AbstractMap.SimpleImmutableEntry<String, JsonValue> pair = new AbstractMap.SimpleImmutableEntry<String, JsonValue>(key, value);
            ++this.index;
            return pair;
        }
    }

    private static class EntrySet
    extends AbstractSet<Map.Entry<String, JsonValue>> {
        private final String[] keys;
        private final JsonValue[] values;

        EntrySet(String[] keys, JsonValue[] values) {
            this.keys = keys;
            this.values = values;
        }

        @Override
        public int size() {
            return this.keys.length;
        }

        @Override
        public Iterator<Map.Entry<String, JsonValue>> iterator() {
            return new EntryIterator(this.keys, this.values);
        }
    }

    public static class Builder {
        private final LinkedHashMap<String, JsonValue> map = new LinkedHashMap();

        private Builder() {
        }

        public JsonObject build() {
            return JsonObject.ofMap(this.map);
        }

        public Builder put(String key, JsonValue value) {
            if (key == null) {
                throw new NullPointerException("key is null.");
            }
            if (value == null) {
                throw new NullPointerException("value is null.");
            }
            this.map.put(key, value);
            return this;
        }

        public Builder put(JsonString key, JsonValue value) {
            if (key == null) {
                throw new NullPointerException("key is null.");
            }
            if (value == null) {
                throw new NullPointerException("value is null.");
            }
            this.map.put(key.getString(), value);
            return this;
        }

        public Builder putEntry(Map.Entry<String, JsonValue> entry) {
            if (entry == null) {
                throw new NullPointerException("entry is null.");
            }
            String key = entry.getKey();
            if (key == null) {
                throw new NullPointerException("entry has null key.");
            }
            JsonValue value = entry.getValue();
            if (value == null) {
                throw new NullPointerException("entry has null value.");
            }
            this.put(key, value);
            return this;
        }

        public Builder putEntryWithJsonStringKey(Map.Entry<JsonString, JsonValue> entry) {
            if (entry == null) {
                throw new NullPointerException("entry is null.");
            }
            JsonString key = entry.getKey();
            if (key == null) {
                throw new NullPointerException("entry has null key.");
            }
            JsonValue value = entry.getValue();
            if (value == null) {
                throw new NullPointerException("entry has null value.");
            }
            this.put(key.getString(), value);
            return this;
        }

        public Builder putAll(Map<String, JsonValue> map) {
            if (map == null) {
                throw new NullPointerException("map is null.");
            }
            for (Map.Entry<String, JsonValue> entry : map.entrySet()) {
                this.putEntry(entry);
            }
            return this;
        }

        public Builder putAllWithJsonStringKeys(Map<JsonString, JsonValue> map) {
            if (map == null) {
                throw new NullPointerException("map is null.");
            }
            for (Map.Entry<JsonString, JsonValue> entry : map.entrySet()) {
                this.putEntryWithJsonStringKey(entry);
            }
            return this;
        }
    }
}

