/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient;

import java.util.List;
import org.embulk.base.restclient.ConfigDiffBuildable;
import org.embulk.base.restclient.DefaultServiceDataSplitter;
import org.embulk.base.restclient.InputTaskValidatable;
import org.embulk.base.restclient.RestClientInputPluginDelegate;
import org.embulk.base.restclient.RestClientInputTaskBase;
import org.embulk.base.restclient.RestClientPluginBase;
import org.embulk.base.restclient.ServiceDataIngestable;
import org.embulk.base.restclient.ServiceDataSplitter;
import org.embulk.base.restclient.ServiceDataSplitterBuildable;
import org.embulk.base.restclient.ServiceResponseMapper;
import org.embulk.base.restclient.ServiceResponseMapperBuildable;
import org.embulk.base.restclient.record.ValueLocator;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Exec;
import org.embulk.spi.InputPlugin;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.Schema;
import org.embulk.util.config.ConfigMapperFactory;

public class RestClientInputPluginBaseUnsafe<T extends RestClientInputTaskBase>
extends RestClientPluginBase<T>
implements InputPlugin {
    private static final boolean HAS_EXEC_GET_PAGE_BUILDER = RestClientInputPluginBaseUnsafe.hasExecGetPageBuilder();
    private final Class<T> taskClass;
    private final ConfigDiffBuildable<T> configDiffBuilder;
    private final InputTaskValidatable<T> inputTaskValidator;
    private final ServiceDataSplitterBuildable<T> serviceDataSplitterBuilder;
    private final ServiceDataIngestable<T> serviceDataIngester;
    private final ServiceResponseMapperBuildable<T> serviceResponseMapperBuilder;

    protected RestClientInputPluginBaseUnsafe(ConfigMapperFactory configMapperFactory, Class<T> taskClass, ConfigDiffBuildable<T> configDiffBuilder, InputTaskValidatable<T> inputTaskValidator, ServiceDataIngestable<T> serviceDataIngester, ServiceDataSplitterBuildable<T> serviceDataSplitterBuilder, ServiceResponseMapperBuildable<T> serviceResponseMapperBuilder) {
        super(configMapperFactory);
        this.taskClass = taskClass;
        this.configDiffBuilder = configDiffBuilder;
        this.inputTaskValidator = inputTaskValidator;
        this.serviceDataIngester = serviceDataIngester;
        this.serviceDataSplitterBuilder = serviceDataSplitterBuilder;
        this.serviceResponseMapperBuilder = serviceResponseMapperBuilder;
    }

    protected RestClientInputPluginBaseUnsafe(ConfigMapperFactory configMapperFactory, Class<T> taskClass, ConfigDiffBuildable<T> configDiffBuilder, InputTaskValidatable<T> inputTaskValidator, ServiceDataIngestable<T> serviceDataIngester, ServiceResponseMapperBuildable<T> serviceResponseMapperBuilder) {
        this(configMapperFactory, taskClass, configDiffBuilder, inputTaskValidator, serviceDataIngester, new ServiceDataSplitterBuildable<T>(){

            @Override
            public ServiceDataSplitter<T> buildServiceDataSplitter(T task) {
                return new DefaultServiceDataSplitter();
            }
        }, serviceResponseMapperBuilder);
    }

    protected RestClientInputPluginBaseUnsafe(ConfigMapperFactory configMapperFactory, Class<T> taskClass, RestClientInputPluginDelegate<T> delegate) {
        this(configMapperFactory, taskClass, delegate, delegate, delegate, delegate, delegate);
    }

    public ConfigDiff transaction(ConfigSource config, InputPlugin.Control control) {
        RestClientInputTaskBase task = (RestClientInputTaskBase)this.loadConfig(config, this.taskClass);
        this.inputTaskValidator.validateInputTask(task);
        int taskCount = this.serviceDataSplitterBuilder.buildServiceDataSplitter(task).numberToSplitWithHintingInTask(task);
        Schema schema = this.serviceResponseMapperBuilder.buildServiceResponseMapper(task).getEmbulkSchema();
        return this.resume(task.toTaskSource(), schema, taskCount, control);
    }

    public ConfigDiff resume(TaskSource taskSource, Schema schema, int taskCount, InputPlugin.Control control) {
        RestClientInputTaskBase task = (RestClientInputTaskBase)this.loadTask(taskSource, this.taskClass);
        List taskReports = control.run(taskSource, schema, taskCount);
        return this.configDiffBuilder.buildConfigDiff(task, schema, taskCount, taskReports);
    }

    public void cleanup(TaskSource taskSource, Schema schema, int taskCount, List<TaskReport> successTaskReports) {
    }

    public TaskReport run(TaskSource taskSource, Schema schema, int taskIndex, PageOutput output) {
        RestClientInputTaskBase task = (RestClientInputTaskBase)this.loadTask(taskSource, this.taskClass);
        this.serviceDataSplitterBuilder.buildServiceDataSplitter(task).hintInEachSplitTask(task, schema, taskIndex);
        ServiceResponseMapper<ValueLocator> serviceResponseMapper = this.serviceResponseMapperBuilder.buildServiceResponseMapper(task);
        try (PageBuilder pageBuilder = RestClientInputPluginBaseUnsafe.getPageBuilder(Exec.getBufferAllocator(), schema, output);){
            TaskReport taskReport = this.serviceDataIngester.ingestServiceData(task, serviceResponseMapper.createRecordImporter(), taskIndex, pageBuilder);
            if (taskReport == null) {
                throw new NullPointerException("TaskReport is unexpectedly null.");
            }
            pageBuilder.finish();
            TaskReport taskReport2 = taskReport;
            return taskReport2;
        }
    }

    public ConfigDiff guess(ConfigSource config) {
        return this.newConfigDiff();
    }

    private static PageBuilder getPageBuilder(BufferAllocator bufferAllocator, Schema schema, PageOutput output) {
        if (HAS_EXEC_GET_PAGE_BUILDER) {
            return Exec.getPageBuilder((BufferAllocator)bufferAllocator, (Schema)schema, (PageOutput)output);
        }
        return new PageBuilder(bufferAllocator, schema, output);
    }

    private static boolean hasExecGetPageBuilder() {
        try {
            Exec.class.getMethod("getPageBuilder", BufferAllocator.class, Schema.class, PageOutput.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }
}

