/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient;

import java.util.List;
import org.embulk.base.restclient.EmbulkDataEgestable;
import org.embulk.base.restclient.OutputTaskValidatable;
import org.embulk.base.restclient.RecordBufferBuildable;
import org.embulk.base.restclient.RestClientOutputPluginDelegate;
import org.embulk.base.restclient.RestClientOutputTaskBase;
import org.embulk.base.restclient.RestClientPageOutput;
import org.embulk.base.restclient.RestClientPluginBase;
import org.embulk.base.restclient.ServiceRequestMapper;
import org.embulk.base.restclient.ServiceRequestMapperBuildable;
import org.embulk.base.restclient.record.ValueLocator;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.spi.OutputPlugin;
import org.embulk.spi.Schema;
import org.embulk.spi.TransactionalPageOutput;
import org.embulk.util.config.ConfigMapperFactory;

public class RestClientOutputPluginBaseUnsafe<T extends RestClientOutputTaskBase>
extends RestClientPluginBase<T>
implements OutputPlugin {
    private final Class<T> taskClass;
    private final EmbulkDataEgestable<T> embulkDataEgester;
    private final RecordBufferBuildable<T> recordBufferBuilder;
    private final OutputTaskValidatable<T> outputTaskValidator;
    private final ServiceRequestMapperBuildable<T> serviceRequestMapperBuilder;

    protected RestClientOutputPluginBaseUnsafe(ConfigMapperFactory configMapperFactory, Class<T> taskClass, EmbulkDataEgestable<T> embulkDataEgester, RecordBufferBuildable<T> recordBufferBuilder, OutputTaskValidatable<T> outputTaskValidator, ServiceRequestMapperBuildable<T> serviceRequestMapperBuilder) {
        super(configMapperFactory);
        this.taskClass = taskClass;
        this.embulkDataEgester = embulkDataEgester;
        this.recordBufferBuilder = recordBufferBuilder;
        this.outputTaskValidator = outputTaskValidator;
        this.serviceRequestMapperBuilder = serviceRequestMapperBuilder;
    }

    protected RestClientOutputPluginBaseUnsafe(ConfigMapperFactory configMapperFactory, Class<T> taskClass, RestClientOutputPluginDelegate<T> delegate) {
        this(configMapperFactory, taskClass, delegate, delegate, delegate, delegate);
    }

    public ConfigDiff transaction(ConfigSource config, Schema schema, int taskCount, OutputPlugin.Control control) {
        RestClientOutputTaskBase task = (RestClientOutputTaskBase)this.loadConfig(config, this.taskClass);
        this.outputTaskValidator.validateOutputTask(task, schema, taskCount);
        return this.resume(task.toTaskSource(), schema, taskCount, control);
    }

    public ConfigDiff resume(TaskSource taskSource, Schema schema, int taskCount, OutputPlugin.Control control) {
        RestClientOutputTaskBase task = (RestClientOutputTaskBase)this.loadTask(taskSource, this.taskClass);
        List taskReports = control.run(taskSource);
        return this.embulkDataEgester.egestEmbulkData(task, schema, taskCount, taskReports);
    }

    public void cleanup(TaskSource taskSource, Schema schema, int taskCount, List<TaskReport> successTaskReports) {
    }

    public TransactionalPageOutput open(TaskSource taskSource, Schema schema, int taskIndex) {
        RestClientOutputTaskBase task = (RestClientOutputTaskBase)this.loadTask(taskSource, this.taskClass);
        ServiceRequestMapper<ValueLocator> serviceRequestMapper = this.serviceRequestMapperBuilder.buildServiceRequestMapper(task);
        return new RestClientPageOutput<RestClientOutputTaskBase>(this.getConfigMapperFactory(), this.taskClass, task, serviceRequestMapper.createRecordExporter(), this.recordBufferBuilder.buildRecordBuffer(task, schema, taskIndex), schema, taskIndex);
    }
}

