/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient;

import org.embulk.base.restclient.RestClientOutputTaskBase;
import org.embulk.base.restclient.record.RecordBuffer;
import org.embulk.base.restclient.record.RecordExporter;
import org.embulk.base.restclient.record.ServiceRecord;
import org.embulk.base.restclient.record.SinglePageRecordReader;
import org.embulk.config.TaskReport;
import org.embulk.spi.Exec;
import org.embulk.spi.Page;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;
import org.embulk.spi.TransactionalPageOutput;
import org.embulk.util.config.ConfigMapperFactory;

public class RestClientPageOutput<T extends RestClientOutputTaskBase>
implements TransactionalPageOutput {
    private static final boolean HAS_EXEC_GET_PAGE_READER = RestClientPageOutput.hasExecGetPageReader();
    private final ConfigMapperFactory configMapperFactory;
    private final Class<T> taskClass;
    private final T task;
    private final RecordExporter recordExporter;
    private final RecordBuffer recordBuffer;
    private final Schema embulkSchema;
    private final int taskIndex;

    public RestClientPageOutput(ConfigMapperFactory configMapperFactory, Class<T> taskClass, T task, RecordExporter recordExporter, RecordBuffer recordBuffer, Schema embulkSchema, int taskIndex) {
        this.configMapperFactory = configMapperFactory;
        this.taskClass = taskClass;
        this.task = task;
        this.recordExporter = recordExporter;
        this.recordBuffer = recordBuffer;
        this.embulkSchema = embulkSchema;
        this.taskIndex = taskIndex;
    }

    public void add(Page page) {
        PageReader pageReader = RestClientPageOutput.getPageReader(this.embulkSchema);
        pageReader.setPage(page);
        while (pageReader.nextRecord()) {
            SinglePageRecordReader singlePageRecordReader = new SinglePageRecordReader(pageReader);
            ServiceRecord record = this.recordExporter.exportRecord(singlePageRecordReader);
            this.recordBuffer.bufferRecord(record);
        }
    }

    public void finish() {
        this.recordBuffer.finish();
    }

    public void close() {
        this.recordBuffer.close();
    }

    public void abort() {
    }

    public TaskReport commit() {
        return this.recordBuffer.commitWithTaskReportUpdated(this.configMapperFactory.newTaskReport());
    }

    private static PageReader getPageReader(Schema schema) {
        if (HAS_EXEC_GET_PAGE_READER) {
            return Exec.getPageReader((Schema)schema);
        }
        return new PageReader(schema);
    }

    private static boolean hasExecGetPageReader() {
        try {
            Exec.class.getMethod("getPageReader", Schema.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }
}

