/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.embulk.base.restclient.record.EmbulkValueScope;
import org.embulk.base.restclient.record.RecordExporter;
import org.embulk.base.restclient.record.ValueLocator;

public abstract class ServiceRequestMapper<T extends ValueLocator> {
    private final List<Map.Entry<EmbulkValueScope, ColumnOptions<T>>> map;

    protected ServiceRequestMapper(List<Map.Entry<EmbulkValueScope, ColumnOptions<T>>> map) {
        ArrayList<AbstractMap.SimpleEntry<EmbulkValueScope, ColumnOptions<T>>> built = new ArrayList<AbstractMap.SimpleEntry<EmbulkValueScope, ColumnOptions<T>>>();
        for (Map.Entry<EmbulkValueScope, ColumnOptions<T>> entry : map) {
            built.add(new AbstractMap.SimpleEntry<EmbulkValueScope, ColumnOptions<T>>(entry.getKey(), entry.getValue()));
        }
        this.map = Collections.unmodifiableList(built);
    }

    public abstract RecordExporter createRecordExporter();

    protected final Collection<Map.Entry<EmbulkValueScope, ColumnOptions<T>>> entries() {
        return this.map;
    }

    protected static class ColumnOptions<U extends ValueLocator> {
        private final U valueLocator;
        private final Optional<String> timestampFormat;

        public ColumnOptions(U valueLocator) {
            this.valueLocator = valueLocator;
            this.timestampFormat = Optional.empty();
        }

        public ColumnOptions(U valueLocator, String timestampFormat) {
            this.valueLocator = valueLocator;
            this.timestampFormat = Optional.of(timestampFormat);
        }

        public U getValueLocator() {
            return this.valueLocator;
        }

        public Optional<String> getTimestampFormat() {
            return this.timestampFormat;
        }
    }
}

