/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.embulk.base.restclient.record.RecordImporter;
import org.embulk.base.restclient.record.ValueLocator;
import org.embulk.spi.Column;
import org.embulk.spi.Schema;

public abstract class ServiceResponseMapper<T extends ValueLocator> {
    private final List<Map.Entry<Column, ColumnOptions<T>>> map;

    protected ServiceResponseMapper(List<Map.Entry<Column, ColumnOptions<T>>> map) {
        ArrayList<AbstractMap.SimpleEntry<Column, ColumnOptions<T>>> built = new ArrayList<AbstractMap.SimpleEntry<Column, ColumnOptions<T>>>();
        for (Map.Entry<Column, ColumnOptions<T>> entry : map) {
            built.add(new AbstractMap.SimpleEntry<Column, ColumnOptions<T>>(entry.getKey(), entry.getValue()));
        }
        this.map = Collections.unmodifiableList(built);
    }

    public final Schema getEmbulkSchema() {
        ArrayList<Column> built = new ArrayList<Column>();
        for (Map.Entry<Column, ColumnOptions<T>> entry : this.map) {
            built.add(entry.getKey());
        }
        return new Schema(built);
    }

    public abstract RecordImporter createRecordImporter();

    protected final Collection<Map.Entry<Column, ColumnOptions<T>>> entries() {
        return this.map;
    }

    public static class ColumnOptions<U extends ValueLocator> {
        private final U valueLocator;
        private final Optional<String> timestampFormat;

        public ColumnOptions(U valueLocator) {
            this.valueLocator = valueLocator;
            this.timestampFormat = Optional.empty();
        }

        public ColumnOptions(U valueLocator, String timestampFormat) {
            this.valueLocator = valueLocator;
            this.timestampFormat = Optional.of(timestampFormat);
        }

        public U getValueLocator() {
            return this.valueLocator;
        }

        public Optional<String> getTimestampFormat() {
            return this.timestampFormat;
        }
    }
}

