/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient;

import java.time.Instant;
import org.embulk.base.restclient.RestClientInputTaskBase;
import org.embulk.base.restclient.ServiceDataSplitter;
import org.embulk.spi.Schema;

public abstract class TimestampServiceDataSplitter<T extends RestClientInputTaskBase>
extends ServiceDataSplitter<T> {
    @Override
    public final int numberToSplitWithHintingInTask(T taskToHint) {
        Instant beginningOfOverall = this.getBeginningOfOverall(taskToHint);
        Instant endingOfOverall = this.getEndingOfOverall(taskToHint);
        SplitCalculator calculator = this.getSplitCalculator(taskToHint);
        return calculator.calculateNumberToSplit(beginningOfOverall, endingOfOverall);
    }

    @Override
    public final void hintInEachSplitTask(T taskToHint, Schema schema, int taskIndex) {
        Instant beginningOfOverall = this.getBeginningOfOverall(taskToHint);
        Instant endingOfOverall = this.getEndingOfOverall(taskToHint);
        SplitCalculator calculator = this.getSplitCalculator(taskToHint);
        this.setTimestampsOfEachTask(taskToHint, calculator.calculateBeginningOfEachTask(beginningOfOverall, endingOfOverall, taskIndex), calculator.calculateEndingOfEachTask(beginningOfOverall, endingOfOverall, taskIndex));
    }

    protected abstract Instant getBeginningOfOverall(T var1);

    protected abstract Instant getEndingOfOverall(T var1);

    protected abstract SplitCalculator getSplitCalculator(T var1);

    protected abstract void setTimestampsOfEachTask(T var1, Instant var2, Instant var3);

    public static abstract class SplitCalculator {
        public abstract int calculateNumberToSplit(Instant var1, Instant var2);

        public abstract Instant calculateBeginningOfEachTask(Instant var1, Instant var2, int var3);

        public abstract Instant calculateEndingOfEachTask(Instant var1, Instant var2, int var3);
    }
}

