/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.jackson;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.embulk.base.restclient.jackson.JacksonValueLocator;

public class JacksonJsonPointerValueLocator
extends JacksonValueLocator {
    private final JsonPointer pointer;

    public JacksonJsonPointerValueLocator(String pointerString) {
        this.pointer = JsonPointer.compile((String)pointerString);
    }

    public JacksonJsonPointerValueLocator(JsonPointer pointer) {
        this.pointer = pointer;
    }

    @Override
    public JsonNode seekValue(ObjectNode record) {
        return record.at(this.pointer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void placeValue(ObjectNode record, JsonNode value) {
        JsonPointer head = this.pointer.head();
        JsonPointer last = this.pointer.last();
        if (!last.mayMatchProperty()) throw new RuntimeException("FATAL: JSON Pointer must not match any element.");
        JsonNode parent = record.at(head);
        if (last.mayMatchElement()) {
            if (parent.isArray()) {
                ((ArrayNode)parent).set(last.getMatchingIndex(), value);
                return;
            } else {
                if (!parent.isObject()) throw new RuntimeException("Placing a property onto non-object nor non-array.");
                ((ObjectNode)parent).set(last.getMatchingProperty(), value);
            }
            return;
        } else {
            if (!parent.isObject()) throw new RuntimeException("Placing a property onto non-object.");
            ((ObjectNode)parent).set(last.getMatchingProperty(), value);
        }
    }
}

