/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.embulk.base.restclient.jackson.JacksonServiceValue;
import org.embulk.base.restclient.jackson.JacksonValueLocator;
import org.embulk.base.restclient.record.ServiceRecord;
import org.embulk.base.restclient.record.ServiceValue;
import org.embulk.base.restclient.record.ValueLocator;

public class JacksonServiceRecord
extends ServiceRecord {
    private final ObjectNode record;

    public JacksonServiceRecord(ObjectNode record) {
        this.record = record;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public JacksonServiceValue getValue(ValueLocator locator) {
        JacksonValueLocator jacksonLocator;
        try {
            jacksonLocator = (JacksonValueLocator)locator;
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Non-JacksonValueLocator is used to locate a value in JacksonServiceRecord", ex);
        }
        return new JacksonServiceValue(jacksonLocator.seekValue(this.record));
    }

    @Override
    public String toString() {
        return this.record.toString();
    }

    ObjectNode getInternalJsonNode() {
        return this.record;
    }

    public static class Builder
    extends ServiceRecord.Builder {
        private static final ObjectMapper MAPPER = new ObjectMapper();
        private ObjectNode node = MAPPER.createObjectNode();

        @Override
        public void reset() {
            this.node = MAPPER.createObjectNode();
        }

        @Override
        public void add(ServiceValue serviceValue, ValueLocator valueLocator) {
            JacksonValueLocator jacksonValueLocator;
            JacksonServiceValue jacksonServiceValue;
            try {
                jacksonServiceValue = (JacksonServiceValue)serviceValue;
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Non-JacksonServiceValue is given to place in JacksonServiceRecord:", ex);
            }
            try {
                jacksonValueLocator = (JacksonValueLocator)valueLocator;
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Non-JacksonValueLocator is used to place a value in JacksonServiceRecord:", ex);
            }
            jacksonValueLocator.placeValue(this.node, jacksonServiceValue.getInternalJsonNode());
        }

        @Override
        public ServiceRecord build() {
            JacksonServiceRecord built = new JacksonServiceRecord(this.node);
            this.reset();
            return built;
        }
    }
}

