/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.jackson;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.embulk.base.restclient.ServiceResponseMapper;
import org.embulk.base.restclient.jackson.JacksonTopLevelValueLocator;
import org.embulk.base.restclient.jackson.JacksonValueLocator;
import org.embulk.base.restclient.record.RecordImporter;
import org.embulk.base.restclient.record.ValueImporter;
import org.embulk.base.restclient.record.values.BooleanValueImporter;
import org.embulk.base.restclient.record.values.DoubleValueImporter;
import org.embulk.base.restclient.record.values.JsonValueImporter;
import org.embulk.base.restclient.record.values.LongValueImporter;
import org.embulk.base.restclient.record.values.StringValueImporter;
import org.embulk.base.restclient.record.values.TimestampValueImporter;
import org.embulk.spi.Column;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;
import org.embulk.util.json.JsonParser;
import org.embulk.util.timestamp.TimestampFormatter;

public final class JacksonServiceResponseMapper
extends ServiceResponseMapper<JacksonValueLocator> {
    protected JacksonServiceResponseMapper(List<Map.Entry<Column, ServiceResponseMapper.ColumnOptions<JacksonValueLocator>>> map) {
        super(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RecordImporter createRecordImporter() {
        ArrayList<ValueImporter> listBuilder = new ArrayList<ValueImporter>();
        for (Map.Entry entry : this.entries()) {
            listBuilder.add(this.createValueImporter(entry.getKey(), entry.getValue()));
        }
        return new RecordImporter(Collections.unmodifiableList(listBuilder));
    }

    private ValueImporter createValueImporter(Column column, ServiceResponseMapper.ColumnOptions<JacksonValueLocator> columnOptions) {
        Type type = column.getType();
        JacksonValueLocator locator = columnOptions.getValueLocator();
        Optional<String> timestampFormat = columnOptions.getTimestampFormat();
        if (type.equals(Types.BOOLEAN)) {
            return new BooleanValueImporter(column, locator);
        }
        if (type.equals(Types.DOUBLE)) {
            return new DoubleValueImporter(column, locator);
        }
        if (type.equals(Types.LONG)) {
            return new LongValueImporter(column, locator);
        }
        if (type.equals(Types.STRING)) {
            return new StringValueImporter(column, locator);
        }
        if (type.equals(Types.TIMESTAMP)) {
            TimestampFormatter timestampFormatter = TimestampFormatter.builder((String)timestampFormat.orElse("%Y-%m-%d %H:%M:%S.%N %z"), (boolean)true).build();
            return new TimestampValueImporter(column, locator, timestampFormatter);
        }
        if (type.equals(Types.JSON)) {
            JsonParser jsonParser = new JsonParser();
            return new JsonValueImporter(column, locator, jsonParser);
        }
        throw new IllegalStateException();
    }

    public static final class Builder {
        private final ArrayList<Map.Entry<Column, ServiceResponseMapper.ColumnOptions<JacksonValueLocator>>> mapBuilder = new ArrayList();
        private int index = 0;

        private Builder() {
        }

        public synchronized Builder add(String embulkColumnName, Type embulkColumnType) {
            this.mapBuilder.add(new AbstractMap.SimpleEntry<Column, ServiceResponseMapper.ColumnOptions<JacksonTopLevelValueLocator>>(new Column(this.index++, embulkColumnName, embulkColumnType), new ServiceResponseMapper.ColumnOptions<JacksonTopLevelValueLocator>(new JacksonTopLevelValueLocator(embulkColumnName))));
            return this;
        }

        public synchronized Builder add(String embulkColumnName, Type embulkColumnType, String embulkColumnTimestampFormat) {
            this.mapBuilder.add(new AbstractMap.SimpleEntry<Column, ServiceResponseMapper.ColumnOptions<JacksonTopLevelValueLocator>>(new Column(this.index++, embulkColumnName, embulkColumnType), new ServiceResponseMapper.ColumnOptions<JacksonTopLevelValueLocator>(new JacksonTopLevelValueLocator(embulkColumnName), embulkColumnTimestampFormat)));
            return this;
        }

        public synchronized Builder add(JacksonValueLocator valueLocator, String embulkColumnName, Type embulkColumnType) {
            this.mapBuilder.add(new AbstractMap.SimpleEntry<Column, ServiceResponseMapper.ColumnOptions<JacksonValueLocator>>(new Column(this.index++, embulkColumnName, embulkColumnType), new ServiceResponseMapper.ColumnOptions<JacksonValueLocator>(valueLocator)));
            return this;
        }

        public synchronized Builder add(JacksonValueLocator valueLocator, String embulkColumnName, Type embulkColumnType, String embulkColumnTimestampFormat) {
            this.mapBuilder.add(new AbstractMap.SimpleEntry<Column, ServiceResponseMapper.ColumnOptions<JacksonValueLocator>>(new Column(this.index++, embulkColumnName, embulkColumnType), new ServiceResponseMapper.ColumnOptions<JacksonValueLocator>(valueLocator, embulkColumnTimestampFormat)));
            return this;
        }

        public JacksonServiceResponseMapper build() {
            return new JacksonServiceResponseMapper((List<Map.Entry<Column, ServiceResponseMapper.ColumnOptions<JacksonValueLocator>>>)this.mapBuilder);
        }
    }
}

