/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.time.Instant;
import org.embulk.base.restclient.record.ServiceValue;
import org.embulk.util.json.JsonParser;
import org.embulk.util.timestamp.TimestampFormatter;
import org.msgpack.value.Value;

public class JacksonServiceValue
extends ServiceValue {
    private final JsonNode value;

    public JacksonServiceValue(JsonNode value) {
        this.value = value == null ? NullNode.getInstance() : value;
    }

    @Override
    public boolean isNull() {
        return this.value.isNull();
    }

    @Override
    public boolean booleanValue() {
        return this.value.asBoolean();
    }

    @Override
    public double doubleValue() {
        return this.value.asDouble();
    }

    @Override
    public Value jsonValue(JsonParser jsonParser) {
        return jsonParser.parse(this.value.toString());
    }

    @Override
    public long longValue() {
        return this.value.asLong();
    }

    @Override
    public String stringValue() {
        return this.value.asText();
    }

    @Override
    public Instant timestampValue(TimestampFormatter timestampFormatter) {
        return timestampFormatter.parse(this.value.asText());
    }

    JsonNode getInternalJsonNode() {
        return this.value;
    }
}

