/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.jackson;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayDeque;
import org.embulk.base.restclient.jackson.JacksonServiceRecord;
import org.embulk.base.restclient.record.RecordBuffer;
import org.embulk.base.restclient.record.ServiceRecord;
import org.embulk.config.TaskReport;

public class JacksonTaskReportRecordBuffer
extends RecordBuffer {
    private final ArrayDeque<ObjectNode> records = new ArrayDeque();
    private final String attributeName;

    public JacksonTaskReportRecordBuffer(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public void bufferRecord(ServiceRecord serviceRecord) {
        JacksonServiceRecord jacksonServiceRecord;
        try {
            jacksonServiceRecord = (JacksonServiceRecord)serviceRecord;
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(ex);
        }
        this.records.addLast(jacksonServiceRecord.getInternalJsonNode());
    }

    @Override
    public void finish() {
    }

    @Override
    public void close() {
    }

    @Override
    public TaskReport commitWithTaskReportUpdated(TaskReport taskReport) {
        taskReport.set(this.attributeName, this.records);
        return taskReport;
    }
}

