/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.embulk.spi.DataException;

public class StringJsonParser {
    private final ObjectMapper mapper = new ObjectMapper();

    public StringJsonParser() {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, false);
    }

    public ObjectNode parseJsonObject(String jsonText) {
        JsonNode node = this.parseJsonNode(jsonText);
        if (node.isObject()) {
            return (ObjectNode)node;
        }
        throw new DataException("Expected object node: " + jsonText);
    }

    public ArrayNode parseJsonArray(String jsonText) {
        JsonNode node = this.parseJsonNode(jsonText);
        if (node.isArray()) {
            return (ArrayNode)node;
        }
        throw new DataException("Expected array node: " + jsonText);
    }

    private JsonNode parseJsonNode(String jsonText) {
        try {
            return this.mapper.readTree(jsonText);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

