/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.jackson.scope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.embulk.base.restclient.jackson.StringJsonParser;
import org.embulk.base.restclient.jackson.scope.JacksonObjectScopeBase;
import org.embulk.base.restclient.record.SinglePageRecordReader;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.util.timestamp.TimestampFormatter;

public class JacksonAllInObjectScope
extends JacksonObjectScopeBase {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final TimestampFormatter timestampFormatter;
    private final StringJsonParser jsonParser;
    private final boolean fillsJsonNullForEmbulkNull;

    public JacksonAllInObjectScope() {
        this(null, false);
    }

    public JacksonAllInObjectScope(boolean fillsJsonNullForEmbulkNull) {
        this(null, fillsJsonNullForEmbulkNull);
    }

    public JacksonAllInObjectScope(TimestampFormatter timestampFormatter) {
        this(timestampFormatter, false);
    }

    public JacksonAllInObjectScope(TimestampFormatter timestampFormatter, boolean fillsJsonNullForEmbulkNull) {
        this.timestampFormatter = timestampFormatter;
        this.jsonParser = new StringJsonParser();
        this.fillsJsonNullForEmbulkNull = fillsJsonNullForEmbulkNull;
    }

    @Override
    public ObjectNode scopeObject(final SinglePageRecordReader singlePageRecordReader) {
        final ObjectNode resultObject = OBJECT_MAPPER.createObjectNode();
        singlePageRecordReader.getSchema().visitColumns(new ColumnVisitor(){

            public void booleanColumn(Column column) {
                if (!singlePageRecordReader.isNull(column)) {
                    resultObject.put(column.getName(), singlePageRecordReader.getBoolean(column));
                } else if (JacksonAllInObjectScope.this.fillsJsonNullForEmbulkNull) {
                    resultObject.putNull(column.getName());
                }
            }

            public void longColumn(Column column) {
                if (!singlePageRecordReader.isNull(column)) {
                    resultObject.put(column.getName(), singlePageRecordReader.getLong(column));
                } else if (JacksonAllInObjectScope.this.fillsJsonNullForEmbulkNull) {
                    resultObject.putNull(column.getName());
                }
            }

            public void doubleColumn(Column column) {
                if (!singlePageRecordReader.isNull(column)) {
                    resultObject.put(column.getName(), singlePageRecordReader.getDouble(column));
                } else if (JacksonAllInObjectScope.this.fillsJsonNullForEmbulkNull) {
                    resultObject.putNull(column.getName());
                }
            }

            public void stringColumn(Column column) {
                if (!singlePageRecordReader.isNull(column)) {
                    resultObject.put(column.getName(), singlePageRecordReader.getString(column));
                } else if (JacksonAllInObjectScope.this.fillsJsonNullForEmbulkNull) {
                    resultObject.putNull(column.getName());
                }
            }

            public void timestampColumn(Column column) {
                if (!singlePageRecordReader.isNull(column)) {
                    if (JacksonAllInObjectScope.this.timestampFormatter == null) {
                        resultObject.put(column.getName(), singlePageRecordReader.getTimestamp(column).getEpochSecond());
                    } else {
                        resultObject.put(column.getName(), JacksonAllInObjectScope.this.timestampFormatter.format(singlePageRecordReader.getTimestamp(column)));
                    }
                } else if (JacksonAllInObjectScope.this.fillsJsonNullForEmbulkNull) {
                    resultObject.putNull(column.getName());
                }
            }

            public void jsonColumn(Column column) {
                if (!singlePageRecordReader.isNull(column)) {
                    resultObject.set(column.getName(), (JsonNode)JacksonAllInObjectScope.this.jsonParser.parseJsonObject(singlePageRecordReader.getJson(column).toJson()));
                } else {
                    resultObject.putNull(column.getName());
                }
            }
        });
        return resultObject;
    }
}

