/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.record;

import org.embulk.base.restclient.record.ServiceValue;
import org.embulk.base.restclient.record.SinglePageRecordReader;
import org.embulk.spi.Column;
import org.embulk.spi.Schema;
import org.embulk.spi.SchemaConfigException;

public abstract class EmbulkValueScope {
    private Schema cachedSchema = null;
    private Column cachedSingleColumn = null;

    protected EmbulkValueScope() {
    }

    public abstract ServiceValue scopeEmbulkValues(SinglePageRecordReader var1);

    protected final Column cacheSingleColumn(Schema schema, String columnName) {
        if (this.cachedSchema == null) {
            this.cachedSchema = schema;
        }
        if (this.cachedSingleColumn != null) {
            if (!this.cachedSingleColumn.getName().equals(columnName)) {
                throw new SchemaConfigException("Incompatible Embulk Column: " + this.cachedSingleColumn.toString() + " : " + columnName);
            }
            int cachedColumnIndex = this.cachedSingleColumn.getIndex();
            Column columnByIndex = schema.getColumn(cachedColumnIndex);
            if (!columnByIndex.equals((Object)this.cachedSingleColumn)) {
                throw new SchemaConfigException("Incompatible Embulk Column: " + columnByIndex.toString() + " : " + columnName);
            }
            if (!columnByIndex.getName().equals(columnName)) {
                throw new SchemaConfigException("Incompatible Embulk Column: " + this.cachedSingleColumn.toString() + " : " + columnByIndex.toString() + " : " + columnName);
            }
        } else {
            this.cachedSingleColumn = schema.lookupColumn(columnName);
        }
        return this.cachedSingleColumn;
    }
}

