/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.record;

import java.time.Instant;
import org.embulk.spi.Column;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;
import org.msgpack.value.Value;

public class SinglePageRecordReader {
    private static final boolean HAS_GET_TIMESTAMP_COLUMN = SinglePageRecordReader.hasGetTimestampColumn();
    private static final boolean HAS_GET_TIMESTAMP_INT = SinglePageRecordReader.hasGetTimestampInt();
    private static final boolean HAS_GET_TIMESTAMP_INSTANT_COLUMN = SinglePageRecordReader.hasGetTimestampInstantColumn();
    private static final boolean HAS_GET_TIMESTAMP_INSTANT_INT = SinglePageRecordReader.hasGetTimestampInstantInt();
    private final PageReader pageReader;

    public SinglePageRecordReader(PageReader pageReader) {
        this.pageReader = pageReader;
    }

    public Schema getSchema() {
        return this.pageReader.getSchema();
    }

    public boolean isNull(Column column) {
        return this.pageReader.isNull(column);
    }

    public boolean isNull(int columnIndex) {
        return this.pageReader.isNull(columnIndex);
    }

    public boolean getBoolean(Column column) {
        return this.pageReader.getBoolean(column);
    }

    public boolean getBoolean(int columnIndex) {
        return this.pageReader.getBoolean(columnIndex);
    }

    public long getLong(Column column) {
        return this.pageReader.getLong(column);
    }

    public long getLong(int columnIndex) {
        return this.pageReader.getLong(columnIndex);
    }

    public double getDouble(Column column) {
        return this.pageReader.getDouble(column);
    }

    public double getDouble(int columnIndex) {
        return this.pageReader.getDouble(columnIndex);
    }

    public String getString(Column column) {
        return this.pageReader.getString(column);
    }

    public String getString(int columnIndex) {
        return this.pageReader.getString(columnIndex);
    }

    public Instant getTimestamp(Column column) {
        if (HAS_GET_TIMESTAMP_INSTANT_COLUMN) {
            return this.pageReader.getTimestampInstant(column);
        }
        if (HAS_GET_TIMESTAMP_COLUMN) {
            return this.pageReader.getTimestamp(column).getInstant();
        }
        throw new IllegalStateException("Neither PageReader#getTimestamp(Column) nor PageReader#getTimestampInstant(Column) found.");
    }

    public Instant getTimestamp(int columnIndex) {
        if (HAS_GET_TIMESTAMP_INSTANT_INT) {
            return this.pageReader.getTimestampInstant(columnIndex);
        }
        if (HAS_GET_TIMESTAMP_INT) {
            return this.pageReader.getTimestamp(columnIndex).getInstant();
        }
        throw new IllegalStateException("Neither PageReader#getTimestamp(int) nor PageReader#getTimestampInstant(int) found.");
    }

    public Value getJson(Column column) {
        return this.pageReader.getJson(column);
    }

    public Value getJson(int columnIndex) {
        return this.pageReader.getJson(columnIndex);
    }

    private static boolean hasGetTimestampColumn() {
        try {
            PageReader.class.getMethod("getTimestamp", Column.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }

    private static boolean hasGetTimestampInt() {
        try {
            PageReader.class.getMethod("getTimestamp", Integer.TYPE);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }

    private static boolean hasGetTimestampInstantColumn() {
        try {
            PageReader.class.getMethod("getTimestampInstant", Column.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }

    private static boolean hasGetTimestampInstantInt() {
        try {
            PageReader.class.getMethod("getTimestampInstant", Integer.TYPE);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }
}

