/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.base.restclient.record.values;

import java.time.Instant;
import org.embulk.base.restclient.record.ServiceRecord;
import org.embulk.base.restclient.record.ServiceValue;
import org.embulk.base.restclient.record.ValueImporter;
import org.embulk.base.restclient.record.ValueLocator;
import org.embulk.spi.Column;
import org.embulk.spi.DataException;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.time.Timestamp;
import org.embulk.util.timestamp.TimestampFormatter;

public class TimestampValueImporter
extends ValueImporter {
    private static final boolean HAS_SET_TIMESTAMP_INSTANT = TimestampValueImporter.hasSetTimestampInstant();
    private static final boolean HAS_SET_TIMESTAMP_TIMESTAMP = TimestampValueImporter.hasSetTimestampTimestamp();
    private final TimestampFormatter timestampFormatter;

    public TimestampValueImporter(Column column, ValueLocator valueLocator, TimestampFormatter timestampFormatter) {
        super(column, valueLocator);
        this.timestampFormatter = timestampFormatter;
    }

    @Override
    public void findAndImportValue(ServiceRecord record, PageBuilder pageBuilder) {
        try {
            ServiceValue value = this.findValue(record);
            if (value == null || value.isNull()) {
                pageBuilder.setNull(this.getColumnToImport());
            } else {
                TimestampValueImporter.setTimestampToPageBuilder(pageBuilder, this.getColumnToImport(), value.timestampValue(this.timestampFormatter));
            }
        }
        catch (Exception ex) {
            throw new DataException("Failed to import a value for column: " + this.getColumnToImport().getName() + " (" + this.getColumnToImport().getType().getName() + ")", (Throwable)ex);
        }
    }

    private static void setTimestampToPageBuilder(PageBuilder pageBuilder, Column column, Instant instant) {
        if (HAS_SET_TIMESTAMP_INSTANT) {
            pageBuilder.setTimestamp(column, instant);
        } else if (HAS_SET_TIMESTAMP_TIMESTAMP) {
            pageBuilder.setTimestamp(column, Timestamp.ofInstant((Instant)instant));
        } else {
            throw new IllegalStateException("Neither PageBuilder#setTimestamp(Column, Instant) nor PageBuilder#setTimestamp(Column, Timestamp) found.");
        }
    }

    private static boolean hasSetTimestampTimestamp() {
        try {
            PageBuilder.class.getMethod("setTimestamp", Column.class, Timestamp.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }

    private static boolean hasSetTimestampInstant() {
        try {
            PageBuilder.class.getMethod("setTimestamp", Column.class, Instant.class);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return true;
    }
}

