/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.preview;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Locale;
import org.embulk.spi.time.DateTimeZoneJacksonModule;
import org.embulk.spi.time.Instants;
import org.embulk.spi.time.TimestampJacksonModule;
import org.embulk.spi.unit.LocalFileJacksonModule;
import org.embulk.spi.unit.ToStringJacksonModule;
import org.embulk.spi.unit.ToStringMapJacksonModule;
import org.embulk.spi.util.CharsetJacksonModule;
import org.msgpack.value.Value;

final class ValueFormatter {
    private final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private final ObjectMapper objectMapper = new ObjectMapper();

    ValueFormatter() {
        this.objectMapper.registerModule((Module)new DateTimeZoneJacksonModule());
        this.objectMapper.registerModule((Module)new TimestampJacksonModule());
        this.objectMapper.registerModule((Module)new CharsetJacksonModule());
        this.objectMapper.registerModule((Module)new LocalFileJacksonModule());
        this.objectMapper.registerModule((Module)new ToStringJacksonModule());
        this.objectMapper.registerModule((Module)new ToStringMapJacksonModule());
        this.objectMapper.registerModule((Module)new GuavaModule());
        this.objectMapper.registerModule((Module)new Jdk8Module());
        this.objectMapper.registerModule((Module)new JodaModule());
    }

    String valueToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Number) {
            if (obj instanceof Integer) {
                return this.numberFormat.format(((Integer)obj).longValue());
            }
            if (obj instanceof Long) {
                return this.numberFormat.format((Long)obj);
            }
            return obj.toString();
        }
        if (obj instanceof Instant) {
            return Instants.toString((Instant)((Instant)obj));
        }
        if (obj instanceof Value) {
            return obj.toString();
        }
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

