/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.embulk.config.ConfigSource;
import org.embulk.deps.config.ConfigLoaderDelegate;
import org.embulk.deps.config.DataSourceImpl;
import org.embulk.deps.config.ModelManagerDelegate;
import org.embulk.deps.config.ModelManagerDelegateImpl;
import org.embulk.deps.config.YamlProcessor;

public class ConfigLoaderDelegateImpl
extends ConfigLoaderDelegate {
    private final ModelManagerDelegateImpl model;

    public ConfigLoaderDelegateImpl(ModelManagerDelegate model) {
        this.model = (ModelManagerDelegateImpl)model;
    }

    public ConfigSource newConfigSource() {
        return new DataSourceImpl(this.model);
    }

    public ConfigSource fromJsonString(String string) {
        JsonNode node;
        try {
            node = new ObjectMapper().readTree(string);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        ConfigLoaderDelegateImpl.validateJsonNode(node);
        return new DataSourceImpl(this.model, (ObjectNode)node);
    }

    public ConfigSource fromJsonFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            ConfigSource configSource = this.fromJson(is);
            return configSource;
        }
    }

    public ConfigSource fromJson(InputStream stream) throws IOException {
        JsonNode node = new ObjectMapper().readTree(stream);
        ConfigLoaderDelegateImpl.validateJsonNode(node);
        return new DataSourceImpl(this.model, (ObjectNode)node);
    }

    public ConfigSource fromYamlString(String string) {
        YamlProcessor yamlProc = YamlProcessor.create((boolean)true);
        JsonNode node = this.objectToJson(yamlProc.load(string));
        ConfigLoaderDelegateImpl.validateJsonNode(node);
        return new DataSourceImpl(this.model, (ObjectNode)node);
    }

    public ConfigSource fromYamlFile(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            ConfigSource configSource = this.fromYaml(stream);
            return configSource;
        }
    }

    public ConfigSource fromYaml(InputStream stream) throws IOException {
        YamlProcessor yamlProc = YamlProcessor.create((boolean)true);
        JsonNode node = this.objectToJson(yamlProc.load(stream));
        ConfigLoaderDelegateImpl.validateJsonNode(node);
        return new DataSourceImpl(this.model, (ObjectNode)node);
    }

    private static void validateJsonNode(JsonNode node) {
        if (!node.isObject()) {
            throw new RuntimeJsonMappingException("Expected object to load ConfigSource but got " + node);
        }
    }

    @Deprecated
    public ConfigSource fromJson(JsonParser parser) throws IOException {
        ObjectNode source = (ObjectNode)new ObjectMapper().readTree(parser);
        return new DataSourceImpl(this.model, source);
    }

    public ConfigSource fromPropertiesYamlLiteral(Properties props, String keyPrefix) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String propName : props.stringPropertyNames()) {
            builder.put((Object)propName, (Object)props.getProperty(propName));
        }
        return this.fromPropertiesYamlLiteral((Map<String, String>)builder.build(), keyPrefix);
    }

    public ConfigSource fromPropertiesYamlLiteral(Map<String, String> props, String keyPrefix) {
        ObjectNode source = new ObjectNode(JsonNodeFactory.instance);
        DataSourceImpl ds = new DataSourceImpl(this.model, source);
        YamlProcessor yamlProc = YamlProcessor.create((boolean)true);
        for (Map.Entry<String, String> pair : props.entrySet()) {
            if (!pair.getKey().startsWith(keyPrefix)) continue;
            String keyName = pair.getKey().substring(keyPrefix.length());
            Object parsedValue = yamlProc.load(pair.getValue());
            JsonNode node = this.objectToJson(parsedValue);
            String[] fragments = keyName.split("\\.");
            DataSourceImpl key = ds;
            for (int i = 0; i < fragments.length - 1; ++i) {
                key = key.getNestedOrSetEmpty(fragments[i]);
            }
            key.set(fragments[fragments.length - 1], node);
        }
        return new DataSourceImpl(this.model, source);
    }

    @Deprecated
    public ConfigSource fromPropertiesAsIs(Properties properties) {
        ObjectNode sourceNode = new ObjectNode(JsonNodeFactory.instance);
        DataSourceImpl dataSource = new DataSourceImpl(this.model, sourceNode);
        for (String key : properties.stringPropertyNames()) {
            dataSource.set(key, properties.getProperty(key));
        }
        return new DataSourceImpl(this.model, sourceNode);
    }

    private JsonNode objectToJson(Object object) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.readTree(objectMapper.writeValueAsString(object));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

