/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.embulk.config.ConfigSource;
import org.embulk.deps.config.ModelManagerDelegateImpl;
import org.embulk.spi.ColumnConfig;
import org.embulk.spi.SchemaConfig;

public final class SchemaConfigJacksonModule
extends SimpleModule {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public SchemaConfigJacksonModule(ModelManagerDelegateImpl model) {
        this.addSerializer(SchemaConfig.class, new SchemaConfigSerializer(model));
        this.addDeserializer(SchemaConfig.class, new SchemaConfigDeserializer(model));
    }

    private static class SchemaConfigDeserializer
    extends JsonDeserializer<SchemaConfig> {
        private final ModelManagerDelegateImpl model;

        SchemaConfigDeserializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public SchemaConfig deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonMappingException {
            JsonNode node;
            try {
                node = (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
            }
            catch (JsonParseException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to parse JSON.", (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to process JSON in parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to read JSON in parsing.", (Throwable)ex);
            }
            if (!node.isArray()) {
                throw new JsonMappingException("Expected array to deserialize SchemaConfig", jsonParser.getCurrentLocation());
            }
            ArrayList<ColumnConfig> columnConfigs = new ArrayList<ColumnConfig>();
            for (JsonNode columnConfigNode : (ArrayNode)node) {
                columnConfigs.add(this.model.readObject(ColumnConfig.class, columnConfigNode.traverse()));
            }
            return new SchemaConfig(Collections.unmodifiableList(columnConfigs));
        }
    }

    private static class SchemaConfigSerializer
    extends JsonSerializer<SchemaConfig> {
        private final ModelManagerDelegateImpl model;

        SchemaConfigSerializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public void serialize(SchemaConfig value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ArrayNode array = OBJECT_MAPPER.createArrayNode();
            for (ColumnConfig columnConfig : value.getColumns()) {
                ConfigSource option = columnConfig.getOption();
                ObjectNode object = this.model.writeObjectAsObjectNode(option);
                object.put("name", columnConfig.getName());
                object.put("type", columnConfig.getType().getName());
                array.add((JsonNode)object);
            }
            jsonGenerator.writeTree((TreeNode)array);
        }
    }
}

