/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.embulk.spi.type.Type;
import org.embulk.spi.type.Types;

class TypeDeserializer
extends FromStringDeserializer<Type> {
    private static final Map<String, Type> stringToTypeMap;

    public TypeDeserializer() {
        super(Type.class);
    }

    protected Type _deserialize(String value, DeserializationContext context) throws IOException {
        Type t = stringToTypeMap.get(value);
        if (t == null) {
            throw new JsonMappingException(String.format("Unknown type name '%s'. Supported types are: %s", value, Joiner.on((String)", ").join(stringToTypeMap.keySet())));
        }
        return t;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)Types.BOOLEAN.getName(), (Object)Types.BOOLEAN);
        builder.put((Object)Types.LONG.getName(), (Object)Types.LONG);
        builder.put((Object)Types.DOUBLE.getName(), (Object)Types.DOUBLE);
        builder.put((Object)Types.STRING.getName(), (Object)Types.STRING);
        builder.put((Object)Types.TIMESTAMP.getName(), (Object)Types.TIMESTAMP);
        builder.put((Object)Types.JSON.getName(), (Object)Types.JSON);
        stringToTypeMap = builder.build();
    }
}

