/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.embulk.deps.buffer.PooledBufferAllocator;
import org.embulk.spi.Buffer;
import org.embulk.spi.BufferImpl;

public class PooledBufferAllocatorImpl
extends PooledBufferAllocator {
    private final PooledByteBufAllocator nettyByteBufAllocator;
    private final int pageSize;

    public PooledBufferAllocatorImpl(int pageSize) {
        this.pageSize = pageSize;
        this.nettyByteBufAllocator = new PooledByteBufAllocator(false);
    }

    public Buffer allocate() {
        return this.allocate(this.pageSize);
    }

    public Buffer allocate(int minimumCapacity) {
        int size;
        for (size = this.pageSize; size < minimumCapacity; size *= 2) {
        }
        return new BufferBasedOnNettyByteBuf(this.nettyByteBufAllocator.buffer(size));
    }

    private static class BufferDoubleReleasedException
    extends IllegalStateException {
        public BufferDoubleReleasedException(Throwable alreadyReleasedAt) {
            super("A Buffer detected double release() calls. The buffer has already been released at:", alreadyReleasedAt);
        }
    }

    private static class BufferBasedOnNettyByteBuf
    extends BufferImpl {
        private ByteBuf internalNettyByteBuf;
        private Throwable alreadyReleasedAt;

        private BufferBasedOnNettyByteBuf(ByteBuf internalNettyByteBuf) {
            super(internalNettyByteBuf.array(), internalNettyByteBuf.arrayOffset(), internalNettyByteBuf.capacity());
            this.internalNettyByteBuf = internalNettyByteBuf;
            this.alreadyReleasedAt = null;
        }

        public void release() {
            if (this.alreadyReleasedAt != null) {
                new BufferDoubleReleasedException(this.alreadyReleasedAt).printStackTrace();
            }
            if (this.internalNettyByteBuf != null) {
                this.internalNettyByteBuf.release();
                this.internalNettyByteBuf = null;
                this.alreadyReleasedAt = new Throwable();
            }
        }
    }
}

