/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.DataSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.deps.config.DataSourceImpl;
import org.embulk.deps.config.ModelManagerDelegateImpl;

public class DataSourceSerDe {

    private static class DataSourceSerializer<T extends DataSource>
    extends JsonSerializer<T> {
        private final ModelManagerDelegateImpl model;

        DataSourceSerializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            if (value == null) {
                throw new JsonGenerationException((Throwable)new NullPointerException("DataSourceSerDe.DataSourceSerializer#serialize accepts only non-null value"));
            }
            String valueJsonStringified = value.toJson();
            if (valueJsonStringified == null) {
                throw new JsonGenerationException((Throwable)new NullPointerException("DataSourceSerDe.DataSourceSerializer#serialize accepts only valid DataSource"));
            }
            JsonNode valueJsonNode = this.model.readObject(JsonNode.class, valueJsonStringified);
            if (!valueJsonNode.isObject()) {
                throw new JsonGenerationException((Throwable)new ClassCastException("DataSourceSerDe.DataSourceSerializer#serialize accepts only valid JSON object"));
            }
            ((ObjectNode)valueJsonNode).serialize(jgen, provider);
        }
    }

    private static class DataSourceDeserializer<T extends DataSource>
    extends JsonDeserializer<T> {
        private final ModelManagerDelegateImpl model;
        private final ObjectMapper treeObjectMapper;

        DataSourceDeserializer(ModelManagerDelegateImpl model) {
            this.model = model;
            this.treeObjectMapper = new ObjectMapper();
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonNode json = (JsonNode)this.treeObjectMapper.readTree(jp);
            if (!json.isObject()) {
                throw new JsonMappingException("Expected object to deserialize DataSource", jp.getCurrentLocation());
            }
            return (T)new DataSourceImpl(this.model, (ObjectNode)json);
        }
    }

    public static class SerDeModule
    extends SimpleModule {
        public SerDeModule(ModelManagerDelegateImpl model) {
            this.addSerializer(DataSourceImpl.class, new DataSourceSerializer(model));
            this.addDeserializer(DataSourceImpl.class, new DataSourceDeserializer(model));
            this.addSerializer(ConfigSource.class, new DataSourceSerializer(model));
            this.addDeserializer(ConfigSource.class, new DataSourceDeserializer(model));
            this.addSerializer(TaskSource.class, new DataSourceSerializer(model));
            this.addDeserializer(TaskSource.class, new DataSourceDeserializer(model));
            this.addSerializer(TaskReport.class, new DataSourceSerializer(model));
            this.addDeserializer(TaskReport.class, new DataSourceDeserializer(model));
            this.addSerializer(ConfigDiff.class, new DataSourceSerializer(model));
            this.addDeserializer(ConfigDiff.class, new DataSourceDeserializer(model));
        }
    }
}

