/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.preview;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.embulk.deps.preview.PreviewPrinter;
import org.embulk.deps.preview.ValueFormatter;
import org.embulk.spi.Page;
import org.embulk.spi.Schema;
import org.embulk.spi.util.Pages;

final class VerticalPreviewPrinter
extends PreviewPrinter {
    private final PrintStream out;
    private final Schema schema;
    private final ValueFormatter valueFormatter;
    private final String format;

    VerticalPreviewPrinter(PrintStream out, Schema schema) {
        this.out = out;
        this.schema = schema;
        this.valueFormatter = new ValueFormatter();
        this.format = "%" + VerticalPreviewPrinter.maxColumnNameLength(schema) + "s (%" + VerticalPreviewPrinter.maxColumnTypeNameLength(schema) + "s) : %s%n";
    }

    public final void printAllPages(List<Page> pages) throws IOException {
        List records = Pages.toObjects((Schema)this.schema, pages, (boolean)true);
        int count = 0;
        for (Object[] record : records) {
            this.printRecord(count, record);
            ++count;
        }
    }

    public final void close() throws IOException {
        this.out.close();
    }

    public void finish() {
    }

    private void printRecord(int count, Object ... values) throws IOException {
        this.out.format("*************************** %d ***************************%n", count);
        for (int i = 0; i < this.schema.getColumnCount(); ++i) {
            this.out.format(this.format, this.schema.getColumnName(i), this.schema.getColumnType(i), values[i]);
        }
    }

    private static int maxColumnNameLength(Schema schema) {
        int max = 0;
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            max = Math.max(max, schema.getColumnName(i).length());
        }
        return max;
    }

    private static int maxColumnTypeNameLength(Schema schema) {
        int max = 0;
        for (int i = 0; i < schema.getColumnCount(); ++i) {
            max = Math.max(max, schema.getColumnType(i).toString().length());
        }
        return max;
    }
}

