/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.embulk.spi.unit.ByteSize;

final class ByteSizeJacksonModule
extends SimpleModule {
    public ByteSizeJacksonModule() {
        this.addSerializer(ByteSize.class, new ByteSizeSerializer());
        this.addDeserializer(ByteSize.class, new ByteSizeDeserializer());
    }

    private static ByteSize getByteSize(JsonNode node, JsonParser jsonParser) throws JsonMappingException {
        if (node.isTextual()) {
            return ByteSize.parseByteSize((String)node.asText());
        }
        if (node.isIntegralNumber()) {
            return new ByteSize(node.asLong());
        }
        throw JsonMappingException.from((JsonParser)jsonParser, (String)"ByteSize must be a string or an integer.");
    }

    private static class ByteSizeDeserializer
    extends JsonDeserializer<ByteSize> {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private ByteSizeDeserializer() {
        }

        public ByteSize deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonMappingException {
            JsonNode node;
            try {
                node = (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
            }
            catch (JsonParseException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to parse JSON.", (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to process JSON in parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to read JSON in parsing.", (Throwable)ex);
            }
            return ByteSizeJacksonModule.getByteSize(node, jsonParser);
        }
    }

    private static class ByteSizeSerializer
    extends JsonSerializer<ByteSize> {
        private ByteSizeSerializer() {
        }

        public void serialize(ByteSize value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeString(value.toString());
        }
    }
}

