/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.embulk.config.Config;
import org.embulk.config.ConfigDefault;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigInject;
import org.embulk.config.Task;
import org.embulk.deps.config.GenericTypeReference;
import org.embulk.deps.config.ModelManagerDelegateImpl;
import org.embulk.deps.config.TaskInvocationHandler;

class TaskSerDe {
    TaskSerDe() {
    }

    public static class ConfigTaskDeserializerModule
    extends TaskDeserializerModule {
        public ConfigTaskDeserializerModule(ObjectMapper nestedObjectMapper, ModelManagerDelegateImpl model) {
            super(nestedObjectMapper, model);
        }

        @Override
        public String getModuleName() {
            return "embulk.config.ConfigTaskSerDe";
        }

        @Override
        protected JsonDeserializer<?> newTaskDeserializer(Class<?> raw) {
            return new ConfigTaskDeserializer(this.nestedObjectMapper, this.model, raw);
        }
    }

    public static class TaskDeserializerModule
    extends Module {
        protected final ObjectMapper nestedObjectMapper;
        protected final ModelManagerDelegateImpl model;

        public TaskDeserializerModule(ObjectMapper nestedObjectMapper, ModelManagerDelegateImpl model) {
            this.nestedObjectMapper = nestedObjectMapper;
            this.model = model;
        }

        public String getModuleName() {
            return "embulk.config.TaskSerDe";
        }

        public Version version() {
            return Version.unknownVersion();
        }

        public void setupModule(Module.SetupContext context) {
            context.addDeserializers((Deserializers)new Deserializers.Base(){

                public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
                    Class raw = type.getRawClass();
                    if (Task.class.isAssignableFrom(raw)) {
                        return this.newTaskDeserializer(raw);
                    }
                    return super.findBeanDeserializer(type, config, beanDesc);
                }
            });
        }

        protected JsonDeserializer<?> newTaskDeserializer(Class<?> raw) {
            return new TaskDeserializer(this.nestedObjectMapper, this.model, raw);
        }
    }

    public static class ConfigTaskDeserializer<T>
    extends TaskDeserializer<T> {
        public ConfigTaskDeserializer(ObjectMapper nestedObjectMapper, ModelManagerDelegateImpl model, Class<T> iface) {
            super(nestedObjectMapper, model, iface);
        }

        @Override
        protected Optional<String> getJsonKey(Method getterMethod, String fieldName) {
            Config a = getterMethod.getAnnotation(Config.class);
            if (a != null) {
                return Optional.of(a.value());
            }
            return Optional.empty();
        }

        @Override
        protected Optional<String> getDefaultJsonString(Method getterMethod) {
            ConfigDefault a = getterMethod.getAnnotation(ConfigDefault.class);
            if (a != null && !a.value().isEmpty()) {
                return Optional.of(a.value());
            }
            return super.getDefaultJsonString(getterMethod);
        }
    }

    public static class TaskSerializerModule
    extends SimpleModule {
        public TaskSerializerModule(ObjectMapper nestedObjectMapper) {
            this.addSerializer(Task.class, new TaskSerializer(nestedObjectMapper));
        }
    }

    public static class TaskDeserializer<T>
    extends JsonDeserializer<T> {
        private final ObjectMapper nestedObjectMapper;
        private final ModelManagerDelegateImpl model;
        private final Class<?> iface;
        private final Multimap<String, FieldEntry> mappings;

        public TaskDeserializer(ObjectMapper nestedObjectMapper, ModelManagerDelegateImpl model, Class<T> iface) {
            this.nestedObjectMapper = nestedObjectMapper;
            this.model = model;
            this.iface = iface;
            this.mappings = this.getterMappings(iface);
        }

        protected Multimap<String, FieldEntry> getterMappings(Class<?> iface) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry getter : TaskInvocationHandler.fieldGetters(iface).entries()) {
                Method getterMethod = (Method)getter.getValue();
                String fieldName = (String)getter.getKey();
                if (TaskDeserializer.isConfigInjectAnnotated(getterMethod)) {
                    throw new ConfigException("@ConfigInject (org.embulk.config.ConfigInject) has stopped working since Embulk v0.10.29. Contact a developer of the plugin.");
                }
                Type fieldType = getterMethod.getGenericReturnType();
                Optional<String> jsonKey = this.getJsonKey(getterMethod, fieldName);
                if (!jsonKey.isPresent()) continue;
                Optional<String> defaultJsonString = this.getDefaultJsonString(getterMethod);
                builder.put((Object)jsonKey.get(), (Object)new FieldEntry(fieldName, fieldType, defaultJsonString));
            }
            return builder.build();
        }

        protected Optional<String> getJsonKey(Method getterMethod, String fieldName) {
            return Optional.of(fieldName);
        }

        protected Optional<String> getDefaultJsonString(Method getterMethod) {
            return Optional.empty();
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String key;
            ConcurrentHashMap<String, Object> objects = new ConcurrentHashMap<String, Object>();
            HashMultimap unusedMappings = HashMultimap.create(this.mappings);
            JsonToken current = jp.getCurrentToken();
            if (current == JsonToken.START_OBJECT) {
                current = jp.nextToken();
                key = jp.getCurrentName();
            } else {
                key = jp.nextFieldName();
            }
            while (key != null) {
                JsonToken t = jp.nextToken();
                Collection fields = this.mappings.get((Object)key);
                if (fields.isEmpty()) {
                    jp.skipChildren();
                } else {
                    JsonNode children = (JsonNode)this.nestedObjectMapper.readValue(jp, JsonNode.class);
                    for (FieldEntry field : fields) {
                        Object value = this.nestedObjectMapper.convertValue((Object)children, (TypeReference)new GenericTypeReference(field.getType()));
                        if (value == null) {
                            throw new JsonMappingException("Setting null to a task field is not allowed. Use Optional<T> to represent null.");
                        }
                        objects.put(field.getName(), value);
                        if (unusedMappings.remove((Object)key, (Object)field)) continue;
                        throw new JsonMappingException(String.format("FATAL: Expected to be a bug in Embulk. Mapping \"%s: (%s) %s\" might have already been processed, or not in %s.", key, field.getType().toString(), field.getName(), this.iface.toString()));
                    }
                }
                key = jp.nextFieldName();
            }
            for (Map.Entry unused : unusedMappings.entries()) {
                FieldEntry field = (FieldEntry)unused.getValue();
                if (field.getDefaultJsonString().isPresent()) {
                    Object value = this.nestedObjectMapper.readValue(field.getDefaultJsonString().get(), (TypeReference)new GenericTypeReference(field.getType()));
                    if (value == null) {
                        throw new JsonMappingException("Setting null to a task field is not allowed. Use Optional<T> to represent null.");
                    }
                    objects.put(field.getName(), value);
                    continue;
                }
                throw new JsonMappingException("Field '" + (String)unused.getKey() + "' is required but not set", jp.getCurrentLocation());
            }
            return (T)Proxy.newProxyInstance(this.iface.getClassLoader(), new Class[]{this.iface}, (InvocationHandler)new TaskInvocationHandler(this.model, this.iface, objects));
        }

        private static boolean isConfigInjectAnnotated(Method getterMethod) {
            return getterMethod.getAnnotation(ConfigInject.class) != null;
        }

        private static class FieldEntry {
            private final String name;
            private final Type type;
            private final Optional<String> defaultJsonString;

            public FieldEntry(String name, Type type, Optional<String> defaultJsonString) {
                this.name = name;
                this.type = type;
                this.defaultJsonString = defaultJsonString;
            }

            public String getName() {
                return this.name;
            }

            public Type getType() {
                return this.type;
            }

            public Optional<String> getDefaultJsonString() {
                return this.defaultJsonString;
            }
        }
    }

    public static class TaskSerializer
    extends JsonSerializer<Task> {
        private final ObjectMapper nestedObjectMapper;

        public TaskSerializer(ObjectMapper nestedObjectMapper) {
            this.nestedObjectMapper = nestedObjectMapper;
        }

        public void serialize(Task value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            InvocationHandler handler;
            if (value instanceof Proxy && (handler = Proxy.getInvocationHandler(value)) instanceof TaskInvocationHandler) {
                TaskInvocationHandler h = (TaskInvocationHandler)handler;
                Map<String, Object> objects = h.getObjects();
                jgen.writeStartObject();
                for (Map.Entry<String, Object> pair : objects.entrySet()) {
                    jgen.writeFieldName(pair.getKey());
                    this.nestedObjectMapper.writeValue(jgen, pair.getValue());
                }
                jgen.writeEndObject();
                return;
            }
            throw new UnsupportedOperationException("Serializing Task is not supported");
        }
    }
}

