/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.cli;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.embulk.deps.cli.OptionsWithPlaceholders;
import org.embulk.deps.cli.PlaceholderOption;

final class HelpFormatterWithPlaceholders
extends HelpFormatter {
    private final int prefixWidth;

    HelpFormatterWithPlaceholders(String syntaxPrefix, int prefixWidth) {
        this.prefixWidth = prefixWidth;
        this.setSyntaxPrefix(syntaxPrefix);
    }

    public final void printHelp(PrintWriter printWriter, int width, String commandLineSyntax, String header, Options options, int leftPaddingWidth, int descriptionPaddingWidth, String footer, boolean autoUsage) {
        super.printHelp(printWriter, width, commandLineSyntax, header, options, leftPaddingWidth, descriptionPaddingWidth, footer, autoUsage);
        printWriter.flush();
    }

    protected final StringBuffer renderOptions(StringBuffer buffer, int width, Options options, int leftPaddingWidth, int descriptionPaddingWidth) {
        if (!(options instanceof OptionsWithPlaceholders)) {
            return super.renderOptions(buffer, width, options, leftPaddingWidth, descriptionPaddingWidth);
        }
        List<Option> allOptions = ((OptionsWithPlaceholders)options).getOptionsToRender();
        String leftPadding = super.createPadding(leftPaddingWidth);
        String descriptionPadding = super.createPadding(descriptionPaddingWidth);
        int maxOptionLinePrefixLength = 0;
        HashMap<Option, String> optionLinePrefixes = new HashMap<Option, String>();
        for (Option option : allOptions) {
            StringBuilder optionLinePrefixBuilder = new StringBuilder();
            if (option instanceof PlaceholderOption) continue;
            optionLinePrefixBuilder.append(leftPadding);
            if (option.getOpt() == null) {
                optionLinePrefixBuilder.append("    ").append(this.getLongOptPrefix()).append(option.getLongOpt());
            } else {
                optionLinePrefixBuilder.append(this.getOptPrefix()).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optionLinePrefixBuilder.append(", ").append(this.getLongOptPrefix()).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                String argName = option.getArgName();
                if (argName != null && argName.length() == 0) {
                    optionLinePrefixBuilder.append(' ');
                } else {
                    optionLinePrefixBuilder.append(option.hasLongOpt() ? this.getLongOptSeparator() : " ");
                    optionLinePrefixBuilder.append(argName != null ? option.getArgName() : this.getArgName());
                }
            }
            optionLinePrefixes.put(option, optionLinePrefixBuilder.toString());
            if (maxOptionLinePrefixLength >= optionLinePrefixBuilder.length()) continue;
            maxOptionLinePrefixLength = optionLinePrefixBuilder.length();
        }
        if (maxOptionLinePrefixLength < this.prefixWidth) {
            maxOptionLinePrefixLength = this.prefixWidth;
        }
        for (Option option : allOptions) {
            if (option instanceof PlaceholderOption) {
                buffer.append(option.toString());
            } else {
                StringBuilder lineBuilder = new StringBuilder();
                lineBuilder.append((String)optionLinePrefixes.get(option));
                if (lineBuilder.length() < maxOptionLinePrefixLength) {
                    lineBuilder.append(super.createPadding(maxOptionLinePrefixLength - lineBuilder.length()));
                }
                lineBuilder.append(descriptionPadding);
                if (option.getDescription() != null) {
                    lineBuilder.append(option.getDescription());
                }
                super.renderWrappedText(buffer, width, maxOptionLinePrefixLength + descriptionPaddingWidth, lineBuilder.toString());
            }
            buffer.append(super.getNewLine());
        }
        return buffer;
    }
}

