/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.deps.config.ModelManagerDelegateImpl;
import org.embulk.exec.ResumeState;
import org.embulk.spi.Schema;

final class ResumeStateJacksonModule
extends SimpleModule {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public ResumeStateJacksonModule(ModelManagerDelegateImpl model) {
        this.addSerializer(ResumeState.class, new ResumeStateSerializer(model));
        this.addDeserializer(ResumeState.class, new ResumeStateDeserializer(model));
    }

    private static class ResumeStateDeserializer
    extends JsonDeserializer<ResumeState> {
        private final ModelManagerDelegateImpl model;

        ResumeStateDeserializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public ResumeState deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonMappingException {
            JsonNode node;
            try {
                node = (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
            }
            catch (JsonParseException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to parse JSON.", (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to process JSON in parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to read JSON in parsing.", (Throwable)ex);
            }
            if (!node.isObject()) {
                throw new JsonMappingException("Expected object to deserialize ResumeState", jsonParser.getCurrentLocation());
            }
            ObjectNode object = (ObjectNode)node;
            try {
                ConfigSource execSessionConfigSource = this.model.readObject(ConfigSource.class, object.get("exec_task").traverse());
                TaskSource inputTaskSource = this.model.readObject(TaskSource.class, object.get("in_task").traverse());
                TaskSource outputTaskSource = this.model.readObject(TaskSource.class, object.get("out_task").traverse());
                Schema inputSchema = this.model.readObject(Schema.class, object.get("in_schema").traverse());
                Schema outputSchema = this.model.readObject(Schema.class, object.get("out_schema").traverse());
                JsonNode inputTaskReportsNode = object.get("in_reports");
                if (!inputTaskReportsNode.isArray()) {
                    throw new JsonMappingException("An array is expected for ResumeState's in_reports", jsonParser.getCurrentLocation());
                }
                ArrayList inputTaskReports = new ArrayList();
                for (JsonNode inputTaskReportNode : (ArrayNode)inputTaskReportsNode) {
                    if (inputTaskReportNode == null || inputTaskReportNode.isNull()) {
                        inputTaskReports.add(Optional.empty());
                        continue;
                    }
                    inputTaskReports.add(Optional.of(this.model.readObject(TaskReport.class, inputTaskReportNode.traverse())));
                }
                JsonNode outputTaskReportsNode = object.get("out_reports");
                if (!outputTaskReportsNode.isArray()) {
                    throw new JsonMappingException("An array is expected for ResumeState's out_reports", jsonParser.getCurrentLocation());
                }
                ArrayList outputTaskReports = new ArrayList();
                for (JsonNode outputTaskReportNode : (ArrayNode)outputTaskReportsNode) {
                    if (outputTaskReportNode == null || outputTaskReportNode.isNull()) {
                        outputTaskReports.add(Optional.empty());
                        continue;
                    }
                    outputTaskReports.add(Optional.of(this.model.readObject(TaskReport.class, outputTaskReportNode.traverse())));
                }
                return new ResumeState(execSessionConfigSource, inputTaskSource, outputTaskSource, inputSchema, outputSchema, Collections.unmodifiableList(inputTaskReports), Collections.unmodifiableList(outputTaskReports));
            }
            catch (ConfigException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Invalid object to deserialize ResumeState", (Throwable)ex);
            }
        }
    }

    private static class ResumeStateSerializer
    extends JsonSerializer<ResumeState> {
        private final ModelManagerDelegateImpl model;

        ResumeStateSerializer(ModelManagerDelegateImpl model) {
            this.model = model;
        }

        public void serialize(ResumeState value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ObjectNode object = OBJECT_MAPPER.createObjectNode();
            object.put("exec_task", (JsonNode)this.model.writeObjectAsObjectNode(value.getExecSessionConfigSource()));
            object.put("in_task", (JsonNode)this.model.writeObjectAsObjectNode(value.getInputTaskSource()));
            object.put("out_task", (JsonNode)this.model.writeObjectAsObjectNode(value.getOutputTaskSource()));
            object.put("in_schema", (JsonNode)this.model.writeObjectAsObjectNode(value.getInputSchema()));
            object.put("out_schema", (JsonNode)this.model.writeObjectAsObjectNode(value.getOutputSchema()));
            object.put("in_reports", (JsonNode)this.model.writeObjectAsObjectNode(value.getInputTaskReports()));
            object.put("out_reports", (JsonNode)this.model.writeObjectAsObjectNode(value.getOutputTaskReports()));
            jsonGenerator.writeTree((TreeNode)object);
        }
    }
}

