/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.deps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.embulk.plugin.DefaultPluginType;
import org.embulk.plugin.MavenPluginType;
import org.embulk.plugin.PluginSource;
import org.embulk.plugin.PluginType;
import org.embulk.plugin.maven.MavenExcludeDependency;
import org.embulk.plugin.maven.MavenIncludeDependency;

final class PluginTypeJacksonModule
extends SimpleModule {
    public PluginTypeJacksonModule() {
        this.addSerializer(DefaultPluginType.class, new DefaultPluginTypeSerializer());
        this.addSerializer(MavenPluginType.class, new MavenPluginTypeSerializer());
        this.addDeserializer(PluginType.class, new PluginTypeDeserializer());
    }

    private static PluginType createFromString(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        return DefaultPluginType.create((String)name);
    }

    private static PluginType createFromObjectNode(ObjectNode typeObject) {
        PluginSource.Type sourceType = typeObject.has("source") ? PluginSource.Type.of((String)PluginTypeJacksonModule.getTextual(typeObject, "source", "type")) : PluginSource.Type.DEFAULT;
        switch (sourceType) {
            case DEFAULT: {
                String name = PluginTypeJacksonModule.getTextual(typeObject, "name", "type");
                return PluginTypeJacksonModule.createFromString(name);
            }
            case MAVEN: {
                String name = PluginTypeJacksonModule.getTextual(typeObject, "name", "type");
                String group = PluginTypeJacksonModule.getTextual(typeObject, "group", "type");
                String classifier = PluginTypeJacksonModule.getTextual(typeObject, "classifier", "type");
                String version = PluginTypeJacksonModule.getTextual(typeObject, "version", "type");
                Set<MavenExcludeDependency> excludeDependencies = PluginTypeJacksonModule.getExcludeDependencies(typeObject, "type");
                Set<MavenIncludeDependency> includeDependencies = PluginTypeJacksonModule.getIncludeDependencies(typeObject, "type");
                return MavenPluginType.create((String)name, (String)group, (String)classifier, (String)version, excludeDependencies, includeDependencies);
            }
        }
        throw new IllegalArgumentException("\"source\" must be one of: [\"default\", \"maven\"]");
    }

    static PluginType createFromStringForTesting(String name) {
        return PluginTypeJacksonModule.createFromString(name);
    }

    static PluginType createFromObjectNodeForTesting(ObjectNode typeObject) {
        return PluginTypeJacksonModule.createFromObjectNode(typeObject);
    }

    private static Set<MavenExcludeDependency> getExcludeDependencies(ObjectNode object, String parent) {
        JsonNode overrideDependenciesJson;
        LinkedHashSet<MavenExcludeDependency> excludeDependencies = new LinkedHashSet<MavenExcludeDependency>();
        JsonNode excludeDependenciesJson = object.get("exclude_dependencies");
        if (excludeDependenciesJson != null) {
            if (!excludeDependenciesJson.isArray()) {
                throw new IllegalArgumentException("\"exclude_dependencies\" in \"" + parent + "\" must be an array.");
            }
            for (JsonNode excludeDependencyJson : (ArrayNode)excludeDependenciesJson) {
                excludeDependencies.add(PluginTypeJacksonModule.getExcludeDependency(excludeDependencyJson));
            }
        }
        if ((overrideDependenciesJson = object.get("override_dependencies")) != null) {
            if (!overrideDependenciesJson.isArray()) {
                throw new IllegalArgumentException("\"override_dependencies\" in \"" + parent + "\" must be an array.");
            }
            for (JsonNode overrideDependencyJson : (ArrayNode)overrideDependenciesJson) {
                excludeDependencies.add(PluginTypeJacksonModule.getOverrideDependency(overrideDependencyJson).toMavenExcludeDependency());
            }
        }
        return Collections.unmodifiableSet(excludeDependencies);
    }

    private static Set<MavenIncludeDependency> getIncludeDependencies(ObjectNode object, String parent) {
        LinkedHashSet<MavenIncludeDependency> includeDependencies = new LinkedHashSet<MavenIncludeDependency>();
        JsonNode overrideDependenciesJson = object.get("override_dependencies");
        if (overrideDependenciesJson != null) {
            if (!overrideDependenciesJson.isArray()) {
                throw new IllegalArgumentException("\"override_dependencies\" in \"" + parent + "\" must be an array.");
            }
            for (JsonNode overrideDependencyJson : (ArrayNode)overrideDependenciesJson) {
                includeDependencies.add(PluginTypeJacksonModule.getOverrideDependency(overrideDependencyJson));
            }
        }
        return Collections.unmodifiableSet(includeDependencies);
    }

    private static MavenExcludeDependency getExcludeDependency(JsonNode json) {
        if (json.isArray()) {
            throw new IllegalArgumentException("Elements in \"exclude_dependencies\" must not be an array.");
        }
        if (json.isObject()) {
            ObjectNode excludeDependencyObject = (ObjectNode)json;
            String artifactId = PluginTypeJacksonModule.getTextual(excludeDependencyObject, "artifactId", "exclude_dependencies");
            String groupId = PluginTypeJacksonModule.getTextual(excludeDependencyObject, "groupId", "exclude_dependencies");
            String classifier = PluginTypeJacksonModule.getTextual(excludeDependencyObject, "classifier", "exclude_dependencies");
            return MavenExcludeDependency.of((String)groupId, (String)artifactId, (String)classifier);
        }
        return MavenExcludeDependency.fromString((String)json.asText());
    }

    private static MavenIncludeDependency getOverrideDependency(JsonNode json) {
        if (json.isArray()) {
            throw new IllegalArgumentException("Elements in \"override_dependencies\" must not be an array.");
        }
        if (json.isObject()) {
            ObjectNode overrideDependencyObject = (ObjectNode)json;
            String artifactId = PluginTypeJacksonModule.getTextual(overrideDependencyObject, "artifactId", "override_dependencies");
            String groupId = PluginTypeJacksonModule.getTextual(overrideDependencyObject, "groupId", "override_dependencies");
            String version = PluginTypeJacksonModule.getTextual(overrideDependencyObject, "version", "override_dependencies");
            String classifier = PluginTypeJacksonModule.getTextual(overrideDependencyObject, "classifier", "override_dependencies");
            return MavenIncludeDependency.of((String)groupId, (String)artifactId, (String)version, (String)classifier);
        }
        return MavenIncludeDependency.fromString((String)json.asText());
    }

    private static String getTextual(ObjectNode object, String fieldName, String parent) {
        JsonNode json = object.get(fieldName);
        if (json == null) {
            return null;
        }
        if (!json.isTextual()) {
            throw new IllegalArgumentException("\"" + fieldName + "\" in \"" + parent + "\" must be a textual value.");
        }
        return json.textValue();
    }

    private static class PluginTypeDeserializer
    extends JsonDeserializer<PluginType> {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private PluginTypeDeserializer() {
        }

        public PluginType deserialize(JsonParser jsonParser, DeserializationContext context) throws JsonMappingException {
            JsonNode typeJson;
            try {
                typeJson = (JsonNode)OBJECT_MAPPER.readTree(jsonParser);
            }
            catch (JsonParseException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to parse JSON.", (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to process JSON in parsing.", (Throwable)ex);
            }
            catch (IOException ex) {
                throw JsonMappingException.from((JsonParser)jsonParser, (String)"Failed to read JSON in parsing.", (Throwable)ex);
            }
            if (typeJson.isTextual()) {
                return PluginTypeJacksonModule.createFromString(((TextNode)typeJson).textValue());
            }
            if (typeJson.isObject()) {
                return PluginTypeJacksonModule.createFromObjectNode((ObjectNode)typeJson);
            }
            throw new IllegalArgumentException("\"type\" must be a string or a 1-depth mapping.");
        }
    }

    private static class MavenPluginTypeSerializer
    extends JsonSerializer<MavenPluginType> {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

        private MavenPluginTypeSerializer() {
        }

        public void serialize(MavenPluginType value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            ObjectNode object = OBJECT_MAPPER.createObjectNode();
            object.put("source", value.getSourceName());
            object.put("name", value.getName());
            if (value.getGroup() != null) {
                object.put("group", value.getGroup());
            }
            if (value.getClassifier() != null) {
                object.put("classifier", value.getClassifier());
            }
            if (value.getVersion() != null) {
                object.put("version", value.getVersion());
            }
            jsonGenerator.writeTree((TreeNode)object);
        }
    }

    private static class DefaultPluginTypeSerializer
    extends JsonSerializer<DefaultPluginType> {
        private DefaultPluginTypeSerializer() {
        }

        public void serialize(DefaultPluginType value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeString(value.getName());
        }
    }
}

