/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.formatter.csv;

import java.nio.charset.Charset;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskSource;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.Exec;
import org.embulk.spi.FileOutput;
import org.embulk.spi.FormatterPlugin;
import org.embulk.spi.Page;
import org.embulk.spi.PageOutput;
import org.embulk.spi.PageReader;
import org.embulk.spi.Schema;
import org.embulk.spi.time.Timestamp;
import org.embulk.spi.type.TimestampType;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.text.LineEncoder;
import org.embulk.util.text.Newline;
import org.embulk.util.timestamp.TimestampFormatter;
import org.msgpack.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvFormatterPlugin
implements FormatterPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();
    private static final Logger logger = LoggerFactory.getLogger(CsvFormatterPlugin.class);

    public void transaction(ConfigSource config, Schema schema, FormatterPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        for (String columnName : task.getColumnOptions().keySet()) {
            schema.lookupColumn(columnName);
        }
        control.run(task.dump());
    }

    public PageOutput open(TaskSource taskSource, final Schema schema, FileOutput output) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        final LineEncoder encoder = LineEncoder.of((FileOutput)output, (Newline)task.getNewline(), (Charset)task.getCharset(), (BufferAllocator)Exec.getBufferAllocator());
        final TimestampFormatter[] timestampFormatters = CsvFormatterPlugin.newTimestampColumnFormatters(task, schema, task.getColumnOptions());
        final char delimiter = task.getDelimiterChar();
        final QuotePolicy quotePolicy = task.getQuotePolicy();
        final char quote = task.getQuoteChar() != '\u0000' ? (char)task.getQuoteChar() : (char)'\"';
        final char escape = task.getEscapeChar().orElse(Character.valueOf(quotePolicy == QuotePolicy.NONE ? (char)'\\' : quote)).charValue();
        final String newlineInField = task.getNewlineInField().getString();
        final String nullString = task.getNullString();
        encoder.nextFile();
        if (task.getHeaderLine()) {
            this.writeHeader(schema, encoder, delimiter, quotePolicy, quote, escape, newlineInField, nullString);
        }
        return new PageOutput(){
            private final PageReader pageReader;
            private final String delimiterString;
            {
                this.pageReader = CsvFormatterPlugin.getPageReader(schema);
                this.delimiterString = String.valueOf(delimiter);
            }

            public void add(Page page) {
                this.pageReader.setPage(page);
                while (this.pageReader.nextRecord()) {
                    schema.visitColumns(new ColumnVisitor(){

                        public void booleanColumn(Column column) {
                            this.addDelimiter(column);
                            if (!pageReader.isNull(column)) {
                                this.addValue(Boolean.toString(pageReader.getBoolean(column)));
                            } else {
                                this.addNullString();
                            }
                        }

                        public void longColumn(Column column) {
                            this.addDelimiter(column);
                            if (!pageReader.isNull(column)) {
                                this.addValue(Long.toString(pageReader.getLong(column)));
                            } else {
                                this.addNullString();
                            }
                        }

                        public void doubleColumn(Column column) {
                            this.addDelimiter(column);
                            if (!pageReader.isNull(column)) {
                                this.addValue(Double.toString(pageReader.getDouble(column)));
                            } else {
                                this.addNullString();
                            }
                        }

                        public void stringColumn(Column column) {
                            this.addDelimiter(column);
                            if (!pageReader.isNull(column)) {
                                this.addValue(pageReader.getString(column));
                            } else {
                                this.addNullString();
                            }
                        }

                        public void timestampColumn(Column column) {
                            this.addDelimiter(column);
                            if (!pageReader.isNull(column)) {
                                this.addValue(this.formatTimestamp(column));
                            } else {
                                this.addNullString();
                            }
                        }

                        public void jsonColumn(Column column) {
                            this.addDelimiter(column);
                            if (!pageReader.isNull(column)) {
                                Value value = pageReader.getJson(column);
                                this.addValue(value.toJson());
                            } else {
                                this.addNullString();
                            }
                        }

                        private void addDelimiter(Column column) {
                            if (column.getIndex() != 0) {
                                encoder.addText(delimiterString);
                            }
                        }

                        private void addValue(String v) {
                            encoder.addText(CsvFormatterPlugin.this.setEscapeAndQuoteValue(v, delimiter, quotePolicy, quote, escape, newlineInField, nullString));
                        }

                        private void addNullString() {
                            encoder.addText(nullString);
                        }

                        private String formatTimestamp(Column column) {
                            try {
                                Instant value = pageReader.getTimestampInstant(column);
                                return timestampFormatters[column.getIndex()].format(value);
                            }
                            catch (NoSuchMethodError ex) {
                                Timestamp value = pageReader.getTimestamp(column);
                                return timestampFormatters[column.getIndex()].format(value.getInstant());
                            }
                        }
                    });
                    encoder.addNewLine();
                }
            }

            public void finish() {
                encoder.finish();
            }

            public void close() {
                encoder.close();
            }
        };
    }

    private void writeHeader(Schema schema, LineEncoder encoder, char delimiter, QuotePolicy policy, char quote, char escape, String newline, String nullString) {
        String delimiterString = String.valueOf(delimiter);
        for (Column column : schema.getColumns()) {
            if (column.getIndex() != 0) {
                encoder.addText(delimiterString);
            }
            encoder.addText(this.setEscapeAndQuoteValue(column.getName(), delimiter, policy, quote, escape, newline, nullString));
        }
        encoder.addNewLine();
    }

    private String setEscapeAndQuoteValue(String v, char delimiter, QuotePolicy policy, char quote, char escape, String newline, String nullString) {
        StringBuilder escapedValue = new StringBuilder();
        int previousChar = 32;
        boolean isRequireQuote = policy == QuotePolicy.ALL || policy == QuotePolicy.MINIMAL && v.equals(nullString);
        for (int i = 0; i < v.length(); ++i) {
            char c = v.charAt(i);
            if (policy != QuotePolicy.NONE && c == quote) {
                escapedValue.append(escape);
                escapedValue.append(c);
                isRequireQuote = true;
            } else if (c == '\r') {
                if (policy == QuotePolicy.NONE) {
                    escapedValue.append(escape);
                }
                escapedValue.append(newline);
                isRequireQuote = true;
            } else if (c == '\n') {
                if (previousChar != 13) {
                    if (policy == QuotePolicy.NONE) {
                        escapedValue.append(escape);
                    }
                    escapedValue.append(newline);
                    isRequireQuote = true;
                }
            } else if (c == delimiter) {
                if (policy == QuotePolicy.NONE) {
                    escapedValue.append(escape);
                }
                escapedValue.append(c);
                isRequireQuote = true;
            } else {
                escapedValue.append(c);
            }
            previousChar = c;
        }
        if (policy != QuotePolicy.NONE && isRequireQuote) {
            return this.setQuoteValue(escapedValue.toString(), quote);
        }
        return escapedValue.toString();
    }

    private String setQuoteValue(String v, char quote) {
        StringBuilder sb = new StringBuilder();
        sb.append(quote);
        sb.append(v);
        sb.append(quote);
        return sb.toString();
    }

    private static TimestampFormatter[] newTimestampColumnFormatters(PluginTask task, Schema schema, Map<String, TimestampColumnOption> columnOptions) {
        TimestampFormatter[] formatters = new TimestampFormatter[schema.getColumnCount()];
        int i = 0;
        for (Column column : schema.getColumns()) {
            if (column.getType() instanceof TimestampType) {
                Optional<TimestampColumnOption> columnOption = Optional.ofNullable(columnOptions.get(column.getName()));
                String pattern = columnOption.isPresent() ? columnOption.get().getFormat().orElse(task.getDefaultTimestampFormat()) : task.getDefaultTimestampFormat();
                String zoneIdString = columnOption.isPresent() ? columnOption.get().getTimeZoneId().orElse(task.getDefaultTimeZoneId()) : task.getDefaultTimeZoneId();
                formatters[i] = TimestampFormatter.builder((String)pattern, (boolean)true).setDefaultZoneFromString(zoneIdString).build();
            }
            ++i;
        }
        return formatters;
    }

    private static PageReader getPageReader(Schema schema) {
        try {
            return Exec.getPageReader((Schema)schema);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("embulk-filter-remove_columns is expected to work with Embulk v0.10.17+.", (Throwable)ex);
            return new PageReader(schema);
        }
    }

    public static interface TimestampColumnOption
    extends Task {
        @Config(value="timezone")
        @ConfigDefault(value="null")
        public Optional<String> getTimeZoneId();

        @Config(value="format")
        @ConfigDefault(value="null")
        public Optional<String> getFormat();
    }

    public static interface PluginTask
    extends Task {
        @Config(value="header_line")
        @ConfigDefault(value="true")
        public boolean getHeaderLine();

        @Config(value="delimiter")
        @ConfigDefault(value="\",\"")
        public char getDelimiterChar();

        @Config(value="quote")
        @ConfigDefault(value="\"\\\"\"")
        public char getQuoteChar();

        @Config(value="quote_policy")
        @ConfigDefault(value="\"MINIMAL\"")
        public QuotePolicy getQuotePolicy();

        @Config(value="escape")
        @ConfigDefault(value="null")
        public Optional<Character> getEscapeChar();

        @Config(value="null_string")
        @ConfigDefault(value="\"\"")
        public String getNullString();

        @Config(value="newline_in_field")
        @ConfigDefault(value="\"LF\"")
        public Newline getNewlineInField();

        @Config(value="column_options")
        @ConfigDefault(value="{}")
        public Map<String, TimestampColumnOption> getColumnOptions();

        @Config(value="charset")
        @ConfigDefault(value="\"utf-8\"")
        public Charset getCharset();

        @Config(value="newline")
        @ConfigDefault(value="\"CRLF\"")
        public Newline getNewline();

        @Config(value="default_timezone")
        @ConfigDefault(value="\"UTC\"")
        public String getDefaultTimeZoneId();

        @Config(value="default_timestamp_format")
        @ConfigDefault(value="\"%Y-%m-%d %H:%M:%S.%6N %z\"")
        public String getDefaultTimestampFormat();
    }

    public static enum QuotePolicy {
        ALL("ALL"),
        MINIMAL("MINIMAL"),
        NONE("NONE");

        private final String string;

        private QuotePolicy(String string2) {
            this.string = string2;
        }

        public String getString() {
            return this.string;
        }
    }
}

