/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.config;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.DataException;
import org.embulk.spi.Exec;
import org.embulk.spi.InputPlugin;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.Schema;
import org.embulk.spi.time.Timestamp;
import org.embulk.spi.type.TimestampType;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.config.units.ColumnConfig;
import org.embulk.util.config.units.SchemaConfig;
import org.embulk.util.json.JsonParseException;
import org.embulk.util.json.JsonValueParser;
import org.embulk.util.timestamp.TimestampFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigInputPlugin
implements InputPlugin {
    private static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().build();
    private static final Logger logger = LoggerFactory.getLogger(ConfigInputPlugin.class);

    public ConfigDiff transaction(ConfigSource config, InputPlugin.Control control) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createConfigMapper().map(config, PluginTask.class);
        Schema schema = task.getSchemaConfig().toSchema();
        List<List<List<JsonNode>>> values = task.getValues();
        int taskCount = values.size();
        return this.resume(task.dump(), schema, taskCount, control);
    }

    public ConfigDiff resume(TaskSource taskSource, Schema schema, int taskCount, InputPlugin.Control control) {
        control.run(taskSource, schema, taskCount);
        return CONFIG_MAPPER_FACTORY.newConfigDiff();
    }

    public void cleanup(TaskSource taskSource, Schema schema, int taskCount, List<TaskReport> successTaskReports) {
    }

    public TaskReport run(TaskSource taskSource, Schema schema, int taskIndex, PageOutput output) {
        PluginTask task = (PluginTask)CONFIG_MAPPER_FACTORY.createTaskMapper().map(taskSource, PluginTask.class);
        List<List<JsonNode>> taskValues = task.getValues().get(taskIndex);
        final TimestampFormatter[] timestampFormatters = ConfigInputPlugin.newTimestampColumnFormatters(task, task.getSchemaConfig());
        final JsonValueParser.Builder jsonParserBuilder = JsonValueParser.builder();
        try (final PageBuilder pageBuilder = ConfigInputPlugin.getPageBuilder(Exec.getBufferAllocator(), schema, output);){
            for (final List<JsonNode> rowValues : taskValues) {
                schema.visitColumns(new ColumnVisitor(){

                    public void booleanColumn(Column column) {
                        JsonNode value = (JsonNode)rowValues.get(column.getIndex());
                        if (value == null || value.isNull()) {
                            pageBuilder.setNull(column);
                        } else {
                            pageBuilder.setBoolean(column, value.asBoolean());
                        }
                    }

                    public void longColumn(Column column) {
                        JsonNode value = (JsonNode)rowValues.get(column.getIndex());
                        if (value == null || value.isNull()) {
                            pageBuilder.setNull(column);
                        } else {
                            pageBuilder.setLong(column, value.asLong());
                        }
                    }

                    public void doubleColumn(Column column) {
                        JsonNode value = (JsonNode)rowValues.get(column.getIndex());
                        if (value == null || value.isNull()) {
                            pageBuilder.setNull(column);
                        } else {
                            pageBuilder.setDouble(column, value.asDouble());
                        }
                    }

                    public void stringColumn(Column column) {
                        JsonNode value = (JsonNode)rowValues.get(column.getIndex());
                        if (value == null || value.isNull()) {
                            pageBuilder.setNull(column);
                        } else {
                            pageBuilder.setString(column, value.asText());
                        }
                    }

                    public void timestampColumn(Column column) {
                        JsonNode value = (JsonNode)rowValues.get(column.getIndex());
                        if (value == null || value.isNull()) {
                            pageBuilder.setNull(column);
                        } else {
                            Instant instant;
                            try {
                                instant = timestampFormatters[column.getIndex()].parse(value.asText());
                            }
                            catch (DateTimeParseException ex) {
                                throw new DataException((Throwable)ex);
                            }
                            ConfigInputPlugin.setParsedTimestamp(pageBuilder, column, instant);
                        }
                    }

                    public void jsonColumn(Column column) {
                        JsonNode value = (JsonNode)rowValues.get(column.getIndex());
                        if (value == null || value.isNull()) {
                            pageBuilder.setNull(column);
                        } else {
                            try {
                                pageBuilder.setJson(column, jsonParserBuilder.build(value.toString()).readJsonValue());
                            }
                            catch (JsonParseException ex) {
                                throw new DataException((Throwable)ex);
                            }
                            catch (IOException ex) {
                                throw new DataException((Throwable)ex);
                            }
                        }
                    }
                });
                pageBuilder.addRecord();
            }
            pageBuilder.finish();
        }
        return CONFIG_MAPPER_FACTORY.newTaskReport();
    }

    public ConfigDiff guess(ConfigSource config) {
        return CONFIG_MAPPER_FACTORY.newConfigDiff();
    }

    private static PageBuilder getPageBuilder(BufferAllocator allocator, Schema schema, PageOutput output) {
        try {
            return Exec.getPageBuilder((BufferAllocator)allocator, (Schema)schema, (PageOutput)output);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("embulk-filter-remove_columns is expected to work with Embulk v0.10.17+.", (Throwable)ex);
            return new PageBuilder(allocator, schema, output);
        }
    }

    private static TimestampFormatter[] newTimestampColumnFormatters(PluginTask task, SchemaConfig schema) {
        TimestampFormatter[] formatters = new TimestampFormatter[schema.getColumnCount()];
        int i = 0;
        for (ColumnConfig column : schema.getColumns()) {
            if (column.getType() instanceof TimestampType) {
                TimestampColumnOption columnOption = (TimestampColumnOption)CONFIG_MAPPER_FACTORY.createConfigMapper().map(column.getOption(), TimestampColumnOption.class);
                String pattern = columnOption.getFormat().orElse(task.getDefaultTimestampFormat());
                formatters[i] = TimestampFormatter.builder((String)pattern, (boolean)true).setDefaultZoneFromString(columnOption.getTimeZoneId().orElse(task.getDefaultTimeZoneId())).setDefaultDateFromString(columnOption.getDate().orElse(task.getDefaultDate())).build();
            }
            ++i;
        }
        return formatters;
    }

    private static void setParsedTimestamp(PageBuilder pageBuilder, Column column, Instant instant) {
        try {
            pageBuilder.setTimestamp(column, instant);
        }
        catch (NoSuchMethodError ex) {
            logger.warn("embulk-input-config is expected to work with Embulk v0.10.17+.", (Throwable)ex);
            pageBuilder.setTimestamp(column, Timestamp.ofInstant((Instant)instant));
        }
    }

    private static interface TimestampColumnOption
    extends Task {
        @Config(value="timezone")
        @ConfigDefault(value="null")
        public Optional<String> getTimeZoneId();

        @Config(value="format")
        @ConfigDefault(value="null")
        public Optional<String> getFormat();

        @Config(value="date")
        @ConfigDefault(value="null")
        public Optional<String> getDate();
    }

    private static interface PluginTask
    extends Task {
        @Config(value="columns")
        public SchemaConfig getSchemaConfig();

        @Config(value="values")
        public List<List<List<JsonNode>>> getValues();

        @Config(value="default_timezone")
        @ConfigDefault(value="\"UTC\"")
        public String getDefaultTimeZoneId();

        @Config(value="default_timestamp_format")
        @ConfigDefault(value="\"%Y-%m-%d %H:%M:%S.%N %z\"")
        public String getDefaultTimestampFormat();

        @Config(value="default_date")
        @ConfigDefault(value="\"1970-01-01\"")
        public String getDefaultDate();
    }
}

