/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeMap;
import org.embulk.config.ConfigDiff;
import org.embulk.config.ConfigException;
import org.embulk.config.ConfigSource;
import org.embulk.config.TaskReport;
import org.embulk.config.TaskSource;
import org.embulk.input.jdbc.JdbcColumn;
import org.embulk.input.jdbc.JdbcColumnOption;
import org.embulk.input.jdbc.JdbcInputConnection;
import org.embulk.input.jdbc.JdbcSchema;
import org.embulk.input.jdbc.ToStringMap;
import org.embulk.input.jdbc.getter.ColumnGetter;
import org.embulk.input.jdbc.getter.ColumnGetterFactory;
import org.embulk.spi.BufferAllocator;
import org.embulk.spi.Column;
import org.embulk.spi.DataException;
import org.embulk.spi.Exec;
import org.embulk.spi.InputPlugin;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.PageOutput;
import org.embulk.spi.Schema;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.config.ConfigMapper;
import org.embulk.util.config.ConfigMapperFactory;
import org.embulk.util.config.Task;
import org.embulk.util.config.TaskMapper;
import org.embulk.util.config.modules.ZoneIdModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcInputPlugin
implements InputPlugin {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJdbcInputPlugin.class);
    protected static final ConfigMapperFactory CONFIG_MAPPER_FACTORY = ConfigMapperFactory.builder().addDefaultModules().addModule((Module)ZoneIdModule.withLegacyNames()).build();
    protected static final ConfigMapper CONFIG_MAPPER = CONFIG_MAPPER_FACTORY.createConfigMapper();
    protected static final TaskMapper TASK_MAPPER = CONFIG_MAPPER_FACTORY.createTaskMapper();

    protected Class<? extends PluginTask> getTaskClass() {
        return PluginTask.class;
    }

    protected abstract JdbcInputConnection newConnection(PluginTask var1) throws SQLException;

    public ConfigDiff transaction(ConfigSource config, InputPlugin.Control control) {
        Schema schema;
        PluginTask task = (PluginTask)CONFIG_MAPPER.map(config, this.getTaskClass());
        if (task.getIncremental()) {
            if (task.getOrderBy().isPresent()) {
                throw new ConfigException("order_by option must not be set if incremental is true");
            }
        } else if (!task.getIncrementalColumns().isEmpty()) {
            throw new ConfigException("'incremental: true' must be set if incremental_columns is set");
        }
        try (JdbcInputConnection con = this.newConnection(task);){
            con.showDriverVersion();
            if (task.getBeforeSetup().isPresent()) {
                con.executeUpdate(task.getBeforeSetup().get());
                con.commit();
            }
            schema = this.setupTask(con, task);
        }
        catch (SQLException ex) {
            if (ex.getCause() instanceof UnknownHostException) {
                throw new ConfigException((Throwable)ex);
            }
            throw new RuntimeException(ex);
        }
        return this.buildNextConfigDiff(task, control.run(task.dump(), schema, 1));
    }

    protected Schema setupTask(JdbcInputConnection con, PluginTask task) throws SQLException {
        JdbcInputConnection.PreparedQuery preparedQuery;
        if (task.getTable().isPresent()) {
            String actualTableName = this.normalizeTableNameCase(con, task.getTable().get());
            task.setTable(Optional.of(actualTableName));
        }
        String rawQuery = this.getRawQuery(task, con);
        JdbcSchema querySchema = null;
        if (task.getUseRawQueryWithIncremental()) {
            String temporaryQuery = rawQuery;
            TreeMap<String, Integer> columnNames = con.createColumnNameSortedMap();
            for (int i = 0; i < task.getIncrementalColumns().size(); ++i) {
                columnNames.put(task.getIncrementalColumns().get(i), i);
            }
            for (Map.Entry<String, Integer> column : columnNames.entrySet()) {
                temporaryQuery = temporaryQuery.replace(":" + column.getKey(), "?");
            }
            querySchema = con.getSchemaOfQuery(temporaryQuery);
        } else {
            querySchema = con.getSchemaOfQuery(rawQuery);
        }
        task.setQuerySchema(querySchema);
        if (task.getIncremental()) {
            List<JsonNode> lastRecord;
            List<String> incrementalColumns = task.getIncrementalColumns();
            if (incrementalColumns.isEmpty()) {
                if (!task.getTable().isPresent()) {
                    throw new ConfigException("incremental_columns option must be set if incremental is true and custom query option is set");
                }
                List<String> primaryKeys = con.getPrimaryKeys(task.getTable().get());
                if (primaryKeys.isEmpty()) {
                    throw new ConfigException(String.format(Locale.ENGLISH, "Primary key is not available at the table '%s'. incremental_columns option must be set", task.getTable().get()));
                }
                logger.info("Using primary keys as incremental_columns: {}", primaryKeys);
                task.setIncrementalColumns(primaryKeys);
                incrementalColumns = primaryKeys;
            }
            List<Integer> incrementalColumnIndexes = this.findIncrementalColumnIndexes(querySchema, incrementalColumns);
            task.setIncrementalColumnIndexes(incrementalColumnIndexes);
            if (task.getLastRecord().isPresent()) {
                lastRecord = task.getLastRecord().get();
                if (lastRecord.size() != incrementalColumnIndexes.size()) {
                    throw new ConfigException("Number of values set at last_record must be same with number of columns set at incremental_columns");
                }
            } else {
                lastRecord = null;
            }
            preparedQuery = task.getQuery().isPresent() ? con.wrapIncrementalQuery(rawQuery, querySchema, incrementalColumns, lastRecord, task.getUseRawQueryWithIncremental()) : con.rebuildIncrementalQuery(task.getTable().get(), task.getSelect(), task.getWhere(), querySchema, incrementalColumns, lastRecord);
        } else {
            task.setIncrementalColumnIndexes(Collections.emptyList());
            preparedQuery = new JdbcInputConnection.PreparedQuery(rawQuery, Collections.emptyList());
        }
        task.setBuiltQuery(preparedQuery);
        this.newColumnGetters(con, task, querySchema, null);
        ColumnGetterFactory factory = this.newColumnGetterFactory(null, task.getDefaultTimeZone());
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 0; i < querySchema.getCount(); ++i) {
            JdbcColumn column = querySchema.getColumn(i);
            JdbcColumnOption columnOption = AbstractJdbcInputPlugin.columnOptionOf(task.getColumnOptions(), task.getDefaultColumnOptions(), column, factory.getJdbcType(column.getSqlType()));
            columns.add(new Column(i, column.getName(), factory.newColumnGetter(con, task, column, columnOption).getToType()));
        }
        return new Schema(Collections.unmodifiableList(columns));
    }

    private String normalizeTableNameCase(JdbcInputConnection con, String tableName) throws SQLException {
        if (con.tableExists(tableName)) {
            return tableName;
        }
        String upperTableName = tableName.toUpperCase();
        String lowerTableName = tableName.toLowerCase();
        boolean upperExists = con.tableExists(upperTableName);
        boolean lowerExists = con.tableExists(lowerTableName);
        if (upperExists && lowerExists) {
            throw new ConfigException(String.format("Cannot specify table '%s' because both '%s' and '%s' exist.", tableName, upperTableName, lowerTableName));
        }
        if (upperExists) {
            return upperTableName;
        }
        if (lowerExists) {
            return lowerTableName;
        }
        return tableName;
    }

    private List<Integer> findIncrementalColumnIndexes(JdbcSchema schema, List<String> incrementalColumns) throws SQLException {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String name : incrementalColumns) {
            Optional<Integer> index = schema.findColumn(name);
            if (index.isPresent()) {
                indices.add(index.get());
                continue;
            }
            throw new ConfigException(String.format(Locale.ENGLISH, "Column name '%s' is in incremental_columns option does not exist", name));
        }
        return Collections.unmodifiableList(indices);
    }

    private String getRawQuery(PluginTask task, JdbcInputConnection con) throws SQLException {
        if (task.getQuery().isPresent()) {
            if (task.getTable().isPresent() || task.getSelect().isPresent() || task.getWhere().isPresent() || task.getOrderBy().isPresent()) {
                throw new ConfigException("'table', 'select', 'where' and 'order_by' parameters are unnecessary if 'query' parameter is set.");
            }
            if (task.getUseRawQueryWithIncremental()) {
                String rawQuery = task.getQuery().get();
                for (String columnName : task.getIncrementalColumns()) {
                    if (rawQuery.contains(":" + columnName)) continue;
                    throw new ConfigException(String.format("Column \":%s\" doesn't exist in query string", columnName));
                }
                if (!task.getLastRecord().isPresent()) {
                    throw new ConfigException("'last_record' is required when 'use_raw_query_with_incremental' is set to true");
                }
                if (task.getLastRecord().get().size() != task.getIncrementalColumns().size()) {
                    throw new ConfigException("size of 'last_record' is different from of 'incremental_columns'");
                }
            } else if (!(task.getUseRawQueryWithIncremental() || task.getIncrementalColumns().isEmpty() && !task.getLastRecord().isPresent())) {
                throw new ConfigException("'incremental_columns' and 'last_record' parameters are not supported if 'query' parameter is set and 'use_raw_query_with_incremental' is set to false.");
            }
            return task.getQuery().get();
        }
        if (task.getTable().isPresent()) {
            return con.buildSelectQuery(task.getTable().get(), task.getSelect(), task.getWhere(), task.getOrderBy());
        }
        throw new ConfigException("'table' or 'query' parameter is required");
    }

    public ConfigDiff resume(TaskSource taskSource, Schema schema, int taskCount, InputPlugin.Control control) {
        PluginTask task = (PluginTask)TASK_MAPPER.map(taskSource, this.getTaskClass());
        return this.buildNextConfigDiff(task, control.run(taskSource, schema, taskCount));
    }

    public ConfigDiff guess(ConfigSource config) {
        return CONFIG_MAPPER_FACTORY.newConfigDiff();
    }

    protected ConfigDiff buildNextConfigDiff(PluginTask task, List<TaskReport> reports) {
        ConfigDiff next = CONFIG_MAPPER_FACTORY.newConfigDiff();
        if (reports.size() > 0 && reports.get(0).has("last_record")) {
            TaskReport report = CONFIG_MAPPER_FACTORY.rebuildTaskReport(reports.get(0));
            next.set("last_record", report.get(JsonNode.class, "last_record"));
        } else if (task.getLastRecord().isPresent()) {
            next.set("last_record", task.getLastRecord().get());
        }
        return next;
    }

    public void cleanup(TaskSource taskSource, Schema schema, int taskCount, List<TaskReport> successTaskReports) {
    }

    public TaskReport run(TaskSource taskSource, Schema schema, int taskIndex, PageOutput output) {
        PluginTask task = (PluginTask)TASK_MAPPER.map(taskSource, this.getTaskClass());
        JdbcInputConnection.PreparedQuery builtQuery = task.getBuiltQuery();
        JdbcSchema querySchema = task.getQuerySchema();
        BufferAllocator allocator = Exec.getBufferAllocator();
        PageBuilder pageBuilder = new PageBuilder(allocator, schema, output);
        long totalRows = 0L;
        LastRecordStore lastRecordStore = null;
        try (JdbcInputConnection con = this.newConnection(task);){
            if (task.getBeforeSelect().isPresent()) {
                con.executeUpdate(task.getBeforeSelect().get());
            }
            List<ColumnGetter> getters = this.newColumnGetters(con, task, querySchema, pageBuilder);
            try (JdbcInputConnection.BatchSelect cursor = con.newSelectCursor(builtQuery, getters, task.getFetchRows(), task.getSocketTimeout());){
                long rows;
                while ((rows = this.fetch(cursor, getters, pageBuilder)) > 0L) {
                    totalRows += rows;
                }
            }
            if (task.getIncremental() && totalRows > 0L) {
                lastRecordStore = new LastRecordStore(task.getIncrementalColumnIndexes(), task.getIncrementalColumns());
                lastRecordStore.accept(getters);
            }
            pageBuilder.finish();
            if (task.getAfterSelect().isPresent()) {
                con.executeUpdate(task.getAfterSelect().get());
            }
            con.commit();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        TaskReport report = CONFIG_MAPPER_FACTORY.newTaskReport();
        if (lastRecordStore != null) {
            report.set("last_record", lastRecordStore.getList());
        }
        return report;
    }

    protected ColumnGetterFactory newColumnGetterFactory(PageBuilder pageBuilder, ZoneId dateTimeZone) {
        return new ColumnGetterFactory(pageBuilder, dateTimeZone);
    }

    private List<ColumnGetter> newColumnGetters(JdbcInputConnection con, PluginTask task, JdbcSchema querySchema, PageBuilder pageBuilder) throws SQLException {
        ColumnGetterFactory factory = this.newColumnGetterFactory(pageBuilder, task.getDefaultTimeZone());
        ArrayList<ColumnGetter> getters = new ArrayList<ColumnGetter>();
        for (JdbcColumn c : querySchema.getColumns()) {
            JdbcColumnOption columnOption = AbstractJdbcInputPlugin.columnOptionOf(task.getColumnOptions(), task.getDefaultColumnOptions(), c, factory.getJdbcType(c.getSqlType()));
            getters.add(factory.newColumnGetter(con, task, c, columnOption));
        }
        return Collections.unmodifiableList(getters);
    }

    private static JdbcColumnOption columnOptionOf(Map<String, JdbcColumnOption> columnOptions, Map<String, JdbcColumnOption> defaultColumnOptions, JdbcColumn targetColumn, String targetColumnSQLType) {
        JdbcColumnOption columnOption = columnOptions.get(targetColumn.getName());
        if (columnOption == null) {
            String foundName = null;
            for (Map.Entry<String, JdbcColumnOption> entry : columnOptions.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(targetColumn.getName())) continue;
                if (columnOption != null) {
                    throw new ConfigException(String.format("Cannot specify column '%s' because both '%s' and '%s' exist in column_options.", targetColumn.getName(), foundName, entry.getKey()));
                }
                foundName = entry.getKey();
                columnOption = entry.getValue();
            }
        }
        if (columnOption != null) {
            return columnOption;
        }
        JdbcColumnOption defaultColumnOption = defaultColumnOptions.get(targetColumnSQLType);
        if (defaultColumnOption != null) {
            return defaultColumnOption;
        }
        return (JdbcColumnOption)CONFIG_MAPPER.map(CONFIG_MAPPER_FACTORY.newConfigSource(), JdbcColumnOption.class);
    }

    private long fetch(JdbcInputConnection.BatchSelect cursor, List<ColumnGetter> getters, PageBuilder pageBuilder) throws SQLException {
        ResultSet result = cursor.fetch();
        if (result == null || !result.next()) {
            return 0L;
        }
        List columns = pageBuilder.getSchema().getColumns();
        long rows = 0L;
        long reportRows = 500L;
        do {
            for (int i = 0; i < getters.size(); ++i) {
                int index = i + 1;
                getters.get(i).getAndSet(result, index, (Column)columns.get(i));
            }
            pageBuilder.addRecord();
            if (++rows % reportRows != 0L) continue;
            logger.info(String.format("Fetched %,d rows.", rows));
            reportRows *= 2L;
        } while (result.next());
        return rows;
    }

    protected void addDriverJarToClasspath(String glob) {
        Method addPathMethod;
        ClassLoader loader = this.getClass().getClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            throw new RuntimeException("Plugin is not loaded by URLClassLoader unexpectedly.");
        }
        if (!"org.embulk.plugin.PluginClassLoader".equals(loader.getClass().getName())) {
            throw new RuntimeException("Plugin is not loaded by PluginClassLoader unexpectedly.");
        }
        Path path = Paths.get(glob, new String[0]);
        if (!path.toFile().exists()) {
            throw new ConfigException("The specified driver jar doesn't exist: " + glob);
        }
        try {
            addPathMethod = loader.getClass().getMethod("addPath", Path.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Plugin is not loaded a ClassLoader which has addPath(Path), unexpectedly.");
        }
        try {
            addPathMethod.invoke((Object)loader, Paths.get(glob, new String[0]));
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            if (targetException instanceof MalformedURLException) {
                throw new IllegalArgumentException(targetException);
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new RuntimeException(targetException);
        }
    }

    protected File findPluginRoot() {
        try {
            URL url = this.getClass().getResource("/" + this.getClass().getName().replace('.', '/') + ".class");
            if (url.toString().startsWith("jar:")) {
                url = new URL(url.toString().replaceAll("^jar:", "").replaceAll("![^!]*$", ""));
            }
            File folder = new File(url.toURI()).getParentFile();
            while (true) {
                if (folder == null) {
                    throw new RuntimeException("Cannot find 'embulk-input-xxx' folder.");
                }
                if (folder.getName().startsWith("embulk-input-")) {
                    return folder;
                }
                folder = folder.getParentFile();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void logConnectionProperties(String url, Properties props) {
        Properties maskedProps = new Properties();
        for (String key : props.stringPropertyNames()) {
            if (key.equals("password")) {
                maskedProps.setProperty(key, "***");
                continue;
            }
            maskedProps.setProperty(key, props.getProperty(key));
        }
        logger.info("Connecting to {} options {}", (Object)url, (Object)maskedProps);
    }

    private static class LastRecordStore {
        private final List<Integer> columnIndexes;
        private final JsonNode[] lastValues;
        private final List<String> columnNames;

        public LastRecordStore(List<Integer> columnIndexes, List<String> columnNames) {
            this.columnIndexes = columnIndexes;
            this.lastValues = new JsonNode[columnIndexes.size()];
            this.columnNames = columnNames;
        }

        public void accept(List<ColumnGetter> getters) throws SQLException {
            for (int i = 0; i < this.columnIndexes.size(); ++i) {
                this.lastValues[i] = getters.get(this.columnIndexes.get(i)).encodeToJson();
            }
        }

        public List<JsonNode> getList() {
            ArrayList<JsonNode> values = new ArrayList<JsonNode>();
            for (int i = 0; i < this.lastValues.length; ++i) {
                if (this.lastValues[i] == null || this.lastValues[i].isNull()) {
                    throw new DataException(String.format(Locale.ENGLISH, "incremental_columns can't include null values but the last row is null at column '%s'", this.columnNames.get(i)));
                }
                values.add(this.lastValues[i]);
            }
            return Collections.unmodifiableList(values);
        }
    }

    public static interface PluginTask
    extends Task {
        @Config(value="options")
        @ConfigDefault(value="{}")
        public ToStringMap getOptions();

        @Config(value="table")
        @ConfigDefault(value="null")
        public Optional<String> getTable();

        public void setTable(Optional<String> var1);

        @Config(value="query")
        @ConfigDefault(value="null")
        public Optional<String> getQuery();

        @Config(value="use_raw_query_with_incremental")
        @ConfigDefault(value="false")
        public boolean getUseRawQueryWithIncremental();

        @Config(value="select")
        @ConfigDefault(value="null")
        public Optional<String> getSelect();

        @Config(value="where")
        @ConfigDefault(value="null")
        public Optional<String> getWhere();

        @Config(value="order_by")
        @ConfigDefault(value="null")
        public Optional<String> getOrderBy();

        @Config(value="incremental")
        @ConfigDefault(value="false")
        public boolean getIncremental();

        @Config(value="incremental_columns")
        @ConfigDefault(value="[]")
        public List<String> getIncrementalColumns();

        public void setIncrementalColumns(List<String> var1);

        @Config(value="last_record")
        @ConfigDefault(value="null")
        public Optional<List<JsonNode>> getLastRecord();

        @Config(value="connect_timeout")
        @ConfigDefault(value="300")
        public int getConnectTimeout();

        @Config(value="socket_timeout")
        @ConfigDefault(value="1800")
        public int getSocketTimeout();

        @Config(value="fetch_rows")
        @ConfigDefault(value="10000")
        public int getFetchRows();

        @Config(value="column_options")
        @ConfigDefault(value="{}")
        public Map<String, JdbcColumnOption> getColumnOptions();

        @Config(value="default_timezone")
        @ConfigDefault(value="\"UTC\"")
        public ZoneId getDefaultTimeZone();

        @Config(value="default_column_options")
        @ConfigDefault(value="{}")
        public Map<String, JdbcColumnOption> getDefaultColumnOptions();

        @Config(value="before_setup")
        @ConfigDefault(value="null")
        public Optional<String> getBeforeSetup();

        @Config(value="before_select")
        @ConfigDefault(value="null")
        public Optional<String> getBeforeSelect();

        @Config(value="after_select")
        @ConfigDefault(value="null")
        public Optional<String> getAfterSelect();

        public JdbcInputConnection.PreparedQuery getBuiltQuery();

        public void setBuiltQuery(JdbcInputConnection.PreparedQuery var1);

        public JdbcSchema getQuerySchema();

        public void setQuerySchema(JdbcSchema var1);

        public List<Integer> getIncrementalColumnIndexes();

        public void setIncrementalColumnIndexes(List<Integer> var1);
    }
}

