/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.embulk.input.jdbc.AbstractJdbcInputPlugin;
import org.embulk.input.jdbc.JdbcInputConnection;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;

public class JdbcInputPlugin
extends AbstractJdbcInputPlugin {
    private static final Set<String> loadedJarGlobs = new HashSet<String>();

    @Override
    protected Class<? extends AbstractJdbcInputPlugin.PluginTask> getTaskClass() {
        return GenericPluginTask.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JdbcInputConnection newConnection(AbstractJdbcInputPlugin.PluginTask task) throws SQLException {
        Driver driver;
        GenericPluginTask t = (GenericPluginTask)task;
        if (t.getDriverPath().isPresent()) {
            Set<String> set = loadedJarGlobs;
            synchronized (set) {
                String glob = t.getDriverPath().get();
                if (!loadedJarGlobs.contains(glob)) {
                    this.addDriverJarToClasspath(glob);
                    loadedJarGlobs.add(glob);
                }
            }
        }
        Properties props = new Properties();
        if (t.getUser().isPresent()) {
            props.setProperty("user", t.getUser().get());
        }
        if (t.getPassword().isPresent()) {
            props.setProperty("password", t.getPassword().get());
        }
        props.putAll((Map<?, ?>)t.getOptions());
        this.logConnectionProperties(t.getUrl(), props);
        try {
            driver = (Driver)Class.forName(t.getDriverClass()).newInstance();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try (Connection con = driver.connect(t.getUrl(), props);){
            JdbcInputConnection c = new JdbcInputConnection(con, t.getSchema().orElse(null));
            con = null;
            JdbcInputConnection jdbcInputConnection = c;
            return jdbcInputConnection;
        }
    }

    public static interface GenericPluginTask
    extends AbstractJdbcInputPlugin.PluginTask {
        @Config(value="driver_path")
        @ConfigDefault(value="null")
        public Optional<String> getDriverPath();

        @Config(value="driver_class")
        public String getDriverClass();

        @Config(value="url")
        public String getUrl();

        @Config(value="user")
        @ConfigDefault(value="null")
        public Optional<String> getUser();

        @Config(value="password")
        @ConfigDefault(value="null")
        public Optional<String> getPassword();

        @Config(value="schema")
        @ConfigDefault(value="null")
        public Optional<String> getSchema();
    }
}

