/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Optional;
import org.embulk.input.jdbc.JdbcColumn;

public class JdbcSchema {
    private List<JdbcColumn> columns;

    @JsonCreator
    public JdbcSchema(List<JdbcColumn> columns) {
        this.columns = columns;
    }

    @JsonValue
    public List<JdbcColumn> getColumns() {
        return this.columns;
    }

    public int getCount() {
        return this.columns.size();
    }

    public JdbcColumn getColumn(int i) {
        return this.columns.get(i);
    }

    public String getColumnName(int i) {
        return this.columns.get(i).getName();
    }

    public Optional<Integer> findColumn(String caseInsensitiveName) {
        int i;
        for (i = 0; i < this.columns.size(); ++i) {
            if (!this.getColumn(i).getName().equals(caseInsensitiveName)) continue;
            return Optional.of(i);
        }
        for (i = 0; i < this.columns.size(); ++i) {
            if (!this.getColumn(i).getName().equalsIgnoreCase(caseInsensitiveName)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }
}

