/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.input.jdbc.getter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.embulk.input.jdbc.getter.ColumnGetter;
import org.embulk.spi.Column;
import org.embulk.spi.ColumnVisitor;
import org.embulk.spi.DataException;
import org.embulk.spi.PageBuilder;
import org.embulk.spi.type.Type;

public abstract class AbstractColumnGetter
implements ColumnGetter,
ColumnVisitor {
    protected static final JsonNodeFactory jsonNodeFactory = JsonNodeFactory.instance;
    protected final PageBuilder to;
    private final Type toType;

    public AbstractColumnGetter(PageBuilder to, Type toType) {
        this.to = to;
        this.toType = toType;
    }

    @Override
    public void getAndSet(ResultSet from, int fromIndex, Column toColumn) throws SQLException {
        this.fetch(from, fromIndex);
        if (from.wasNull()) {
            this.to.setNull(toColumn);
        } else {
            toColumn.visit((ColumnVisitor)this);
        }
    }

    protected abstract void fetch(ResultSet var1, int var2) throws SQLException;

    public void booleanColumn(Column column) {
        this.to.setNull(column);
    }

    public void longColumn(Column column) {
        this.to.setNull(column);
    }

    public void doubleColumn(Column column) {
        this.to.setNull(column);
    }

    public void stringColumn(Column column) {
        this.to.setNull(column);
    }

    public void jsonColumn(Column column) {
        this.to.setNull(column);
    }

    public void timestampColumn(Column column) {
        this.to.setNull(column);
    }

    @Override
    public Type getToType() {
        if (this.toType == null) {
            return this.getDefaultToType();
        }
        return this.toType;
    }

    protected abstract Type getDefaultToType();

    @Override
    public JsonNode encodeToJson() {
        throw new DataException(String.format(Locale.ENGLISH, "Column type '%s' set at incremental_columns option is not supported", this.getToType()));
    }

    @Override
    public void decodeFromJsonTo(PreparedStatement toStatement, int toIndex, JsonNode fromValue) throws SQLException {
        throw new DataException(String.format(Locale.ENGLISH, "Converting last_record value %s to column index %d is not supported", fromValue.toString(), toIndex));
    }

    final long roundDoubleToLong(double value) {
        if (Math.getExponent(value) > 1023) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        double z = Math.rint(value);
        if (Math.abs(value - z) == 0.5) {
            return (long)(value + Math.copySign(0.5, value));
        }
        return (long)z;
    }

    final long roundFloatToLong(float value) {
        if (Math.getExponent(value) > 1023) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        double z = Math.rint(value);
        if (Math.abs((double)value - z) == 0.5) {
            return (long)((double)value + Math.copySign(0.5, (double)value));
        }
        return (long)z;
    }
}

